/**********************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;

public class HyadesExecMessageDebug {

	public static final boolean HYADES_EXEC_MSG_DEBUG = System.getenv("HYADES_EXEC_MSG_DEBUG") != null && System.getenv("HYADES_EXEC_MSG_DEBUG").equalsIgnoreCase("TRUE");

	public static final boolean HYADES_PROCESS_LAUNCH_DEBUG = System.getenv("HYADES_PROCESS_LAUNCH_DEBUG") != null && System.getenv("HYADES_PROCESS_LAUNCH_DEBUG").equalsIgnoreCase("TRUE");
	public static final boolean HYADES_CONSOLE_DEBUG = System.getenv("HYADES_CONSOLE_DEBUG") != null && System.getenv("HYADES_CONSOLE_DEBUG").equalsIgnoreCase("TRUE");
	
	public static final boolean HYADES_INC_CMD_DEBUG = System.getenv("HYADES_INC_CMD_DEBUG") != null && System.getenv("HYADES_INC_CMD_DEBUG").equalsIgnoreCase("TRUE");
	public static final boolean HYADES_OUT_CMD_DEBUG = System.getenv("HYADES_OUT_CMD_DEBUG") != null && System.getenv("HYADES_OUT_CMD_DEBUG").equalsIgnoreCase("TRUE");	
	
	public static final boolean HYADES_DATA_DEBUG = System.getenv("HYADES_DATA_DEBUG") != null && System.getenv("HYADES_DATA_DEBUG").equalsIgnoreCase("TRUE");

//	public static final boolean HYADES_EXEC_MSG_DEBUG = true;
	
//	public static final boolean HYADES_INC_CMD_DEBUG = true;
//	public static final boolean HYADES_OUT_CMD_DEBUG = true;
//	
//	public static final boolean HYADES_DATA_DEBUG = true;
	
//	public static final boolean HYADES_PROCESS_LAUNCH_DEBUG = true;
//	public static final boolean HYADES_CONSOLE_DEBUG = true;
	
	private static boolean _writeToConsole = System.getenv("HYADES_MSG_DEBUG_OUTPUT") != null && System.getenv("HYADES_MSG_DEBUG_OUTPUT").equalsIgnoreCase("CONSOLE");
	private static boolean _writeToFile = System.getenv("HYADES_MSG_DEBUG_OUTPUT") != null && System.getenv("HYADES_MSG_DEBUG_OUTPUT").equalsIgnoreCase("FILE");

	private static Object _writeLock = new Object();

	
	public static String convertStackTrace(Exception e) {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw, true);
		
		e.printStackTrace(pw);
		pw.flush();
		sw.flush(); 

		return sw.toString();
	}

	private static String fixDoubleDigit(int x) {
		if(x < 10) return "0"+x;
		else return ""+x;
	}
	
	/**
	 * @param args
	 */
	private static String getCurrentTimestamp() {
		
		StringBuffer sb = new StringBuffer();
		Calendar c = Calendar.getInstance();
		sb.append(c.get(Calendar.MONTH)+1);
		sb.append("/");
		sb.append(c.get(Calendar.DAY_OF_MONTH));
		sb.append("/");
		sb.append(c.get(Calendar.YEAR));
		sb.append(" ");
		sb.append(c.get(Calendar.HOUR_OF_DAY));
		sb.append(":");
		sb.append(fixDoubleDigit(c.get(Calendar.MINUTE)));
		sb.append(":");
		sb.append(fixDoubleDigit(c.get(Calendar.SECOND)));
		sb.append(" .");
		sb.append(c.get(Calendar.MILLISECOND));
		sb.append(" ");
		
		sb.append(" ");
		sb.append(c.get(Calendar.AM_PM) == Calendar.AM ? "AM" : "PM");
		
		return "["+sb.toString()+"]  ";
	}
	
	public static void writeDebugMessage(String message) {
		writeDebugMessage(message, true);
	}
	
	public static void writeDebugMessage(String message, boolean endOfLineCRLF) {
		if(!HYADES_EXEC_MSG_DEBUG) return;	
		
		message = getCurrentTimestamp() + message;
		
		if(_writeToConsole) {
			
			synchronized(_writeLock) {
				if(endOfLineCRLF) {
					System.out.println(message);
				} else {
					System.out.print(message);
				}
			}
			
		} else if(_writeToFile) {
			
			try {
				
				synchronized(_writeLock) {
					
					File f;

					if(System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
						f = new File("c:\\hyades-msg-debug.log");
					} else {
						f = new File("/tmp/hyades-msg-debug.log");
					}
					
					FileWriter fw = new FileWriter(f, true);
					fw.write(message);
					if(endOfLineCRLF) {
						fw.write(System.getProperty("line.separator"));
					}
					fw.flush();
					fw.close();
					
				}
			} catch(Exception e) {
				e.printStackTrace();
			}
			
		}
						
	}

}
