/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ManageFileCommand.java,v 1.4 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.local.common;

/**
 * @author Giridhar.S
 * 
 */
public class ManageFileCommand extends CommandElement implements Constants {
	public static final int GET 		= 0x01;
	public static final int PUT 		= 0x02;
	public static final int DELETE		= 0x03; 

	private long _operation;
	private RAString _filename = new RAString("");;

	public ManageFileCommand() {
		super();
		_tag = RA_MANAGE_FILE;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		int size = super.getSize();

		size += sizeofLong; // operation
		size += _filename.getSize();

		return size;
	}
	
	/**
	 * @return long - the operation
	 */
	public long getOperation()	{
		return _operation;
	}
	
	/**
	 * @return RAString - the file name
	 */
	public String getFilename()	{
		if (_filename != null)
			return _filename.getData();
		return null;
	}
	
	/**
	 * set the operation to be performed.
	 * @param operation
	 */
	public void setOperation(long operation)	{
		_operation=operation;
	}
	
	/**
	 * set file name to be passed to RAC
	 * @param filename
	 */
	public void setFilename(String filename)	{
		_filename= new RAString(filename);
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);

		_operation = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		current = Message.readRAStringFromBuffer(buffer, current, _filename);

		return current;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _operation);
		current = Message.writeRAStringToBuffer(buffer, current, _filename);

		return current;
	}
	
}