/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Message.java,v 1.3 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;


import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Insert the type's description here.
 * Creation date: (6/2/00 1:47:45 PM)
 * @author: Administrator
 */
public class Message implements Constants{


	
	/* The protocol version number */
	protected long _version=RA_VERSION;

	/* Length of the message */
	protected long _type=0;

	/* The ticket number of the message */
	protected long _ticket=0;
/**
 * Insert the method's description here.
 * Creation date: (6/2/00 4:16:27 PM)
 * @return int
 */
public int getSize() {
	return 4*sizeofLong;
}
/**
 * Insert the method's description here.
 * Creation date: (6/2/00 1:48:08 PM)
 * @return long
 */
public long getTicket() {
	return _ticket;
}
/**
 * Insert the method's description here.
 * Creation date: (11/1/00 3:22:45 PM)
 * @return long
 */
public long getType() {
	return _type;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 5:58:37 PM)
 * @return long
 */
public long getVersion() {
	return _version;
}

/**
 * Insert the method's description here.
 * Creation date: (6/2/00 1:50:09 PM)
 * @param buffer byte[]
 * @param length int
 */
public int readFromBuffer(byte[] buffer, int offset) {
	
	/* magic number */
	readRALongFromBuffer(buffer, offset);
	offset+=4;
	
	
	/* version */
	_version=readRALongFromBuffer(buffer, offset);
	offset+=4;

	/* type */
	_type=readRALongFromBuffer(buffer, offset);
	offset+=4;

	/* ticket */
	_ticket=readRALongFromBuffer(buffer, offset);
	offset+=4;

	return offset;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 6:02:05 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public static long readRALongFromBuffer(byte[] buffer, int offset) {
	return (long)(buffer[0+offset]<<24 & 0xff000000)
		  |(long)(buffer[1+offset]<<16 & 0x00ff0000)
		  |(long)(buffer[2+offset]<<8  & 0x0000ff00)
		  |(long)(buffer[3+offset]     & 0x000000ff);	
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 6:03:31 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public static int readRAStringFromBuffer(byte[] buffer, int offset, RAString rastring) {
	long length=Message.readRALongFromBuffer(buffer, offset);
	String data;
	try {
		data=new String(buffer, offset+4, (int)length, "UTF-8");//$NON-NLS-1$
	}
	catch(Throwable e) {
		data=new String(buffer, 0, offset+4, (int)length);
	}
	rastring.setData(data);
	
	return offset+rastring.getSize();
}

public static int readRABinaryArrayFromBuffer(byte[] buffer, int offset, RABinaryArray raarray) {
	long length=Message.readRALongFromBuffer(buffer, offset);
	raarray.setData(buffer, offset+4, (int)length);
	return offset+raarray.getSize();
}

public static int readRAInetAddressFromBuffer(byte[] buffer, int offset, RAInetAddress ipaddr) {
	byte length=buffer[0+offset];
	byte[] address=new byte[length];
	for(int i=0; i<length; i++) {
		address[i]=buffer[1+i];
	}
	
	ipaddr.setLength((int)length);
	ipaddr.setData(address);
	
	return offset+sizeofByte+length;
}


/**
 * Insert the method's description here.
 * Creation date: (6/2/00 1:48:28 PM)
 * @param ticket java.lang.Long
 */
public void setTicket(long ticket) {
	_ticket=ticket;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 5:59:43 PM)
 * @param version long
 */
public void setVersion(long version) {
	_version=version;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 6:02:05 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public static int writeRALongToBuffer(byte[] buffer, int offset, long ralong) {
	buffer[0+offset]=(byte)(ralong>>24 & 0x000000ff);
	buffer[1+offset]=(byte)(ralong>>16 & 0x000000ff);
	buffer[2+offset]=(byte)(ralong>>8  & 0x000000ff);
	buffer[3+offset]=(byte)ralong;
	return offset+4;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 6:03:31 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public static int writeRAStringToBuffer(byte[] buffer, int offset, RAString rastring) {
	byte[] strData;
	try {
		strData=rastring.getData().getBytes("UTF-8");//$NON-NLS-1$
	}
	catch(Throwable e) {
		strData=rastring.getData().getBytes();
	}
	writeRALongToBuffer(buffer, offset, strData.length);
	System.arraycopy((Object)strData, 0, (Object)buffer, offset+4, strData.length);

	return offset+rastring.getSize();
}

public static int writeRABinaryArrayToBuffer(byte[] buffer, int offset, RABinaryArray raarray) {
	if(raarray==null) {
		writeRALongToBuffer(buffer, offset, 0);
		return offset+sizeofLong;
	}
	byte[] data=raarray.getData();
	writeRALongToBuffer(buffer, offset, data.length);
	System.arraycopy(data, 0, buffer, offset+4, data.length);

	return offset+raarray.getSize();
}

public static int writeRAInetAddressToBuffer(byte[] buffer, int offset, RAInetAddress addr) {
	if(addr==null) {
		buffer[offset]=0;
		return offset+sizeofByte;
	}
	try {
		InetAddress address=addr.getAddress();
		if(address==null) {
			buffer[offset]=0;
			return offset+sizeofByte;
		}
		byte[] bytes=address.getAddress();
		buffer[offset+0]=(byte)bytes.length;
		for(int i=0; i<bytes.length; i++) {
			buffer[offset+i+sizeofByte]=bytes[i];	
		}
		return offset+sizeofByte+bytes.length;
		
		
	}
	catch(UnknownHostException e) {
		buffer[offset]=0;
		return offset+sizeofByte;
		
	}
}

/**
 * Insert the method's description here.
 * Creation date: (6/2/00 1:49:08 PM)
 * @return int
 * @param buffer byte[]
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=offset;
	
	/* Insert magic header */
	current=writeRALongToBuffer(buffer, current, RA_MAGIC);

	/* Insert the major and minor */
	current=writeRALongToBuffer(buffer, current, RA_VERSION);

	/* Insert the type */
	current=writeRALongToBuffer(buffer, current, _type);
	
	/* Insert the ticket */
	current=writeRALongToBuffer(buffer, current, _ticket);


	return current;
}
}
