/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorPeerRequestPortCommand.java,v 1.3 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.local.common;

public class MonitorPeerRequestPortCommand extends MonitorPeerRequestCommand {
	private long _peerPort = 10002;
	private long _targetPort = 10002;

	public MonitorPeerRequestPortCommand() {
		super();
		_tag = RA_CONTROLLER_REQUEST_MONITOR_PORT;
	}

	public int getSize() {
		return super.getSize() + (2*sizeofLong);
	}

	public long getPeerPort() {
		return _peerPort;
	}

	public long getTargetPort() {
		return _targetPort;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);

		_targetPort = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		_peerPort = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = super.writeToBuffer(buffer, offset);
		current = Message.writeRALongToBuffer(buffer, current, _targetPort);
		current = Message.writeRALongToBuffer(buffer, current, _peerPort);

		return current;
	}
}
