/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegisteredProcessListCommand.java,v 1.5 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (9/11/00 11:50:44 PM)
 * @author:
 */
public class RegisteredProcessListCommand extends CommandElement implements Constants {
	private int _processListLength=0;
	private long _processList[];

	/**
	 * QueryServerCommand constructor comment.
	 */
	public RegisteredProcessListCommand() {
		super();
		_tag = RA_PROCESS_LIST;
	}
	
	public RegisteredProcessListCommand(long[] p) {
		super();
		_tag = RA_PROCESS_LIST;
		_processList = p;
		_processListLength = p.length;
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (9/12/00 12:14:34 AM)
	 * @return long[]
	 */
	public long[] getProcessList() {
		return _processList;
	}
	/**
	 * getSize method comment.
	 */
	public int getSize() {
		int size = super.getSize();

		size += sizeofLong; //length
		size += (sizeofLong * _processListLength);

		return size;
	}
	/**
	 * readFromBuffer method comment.
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);
		
		_processListLength = (int)Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		
		_processList = new long[_processListLength];
		for(int i = 0; i < _processListLength; i++) {
			_processList[i] = Message.readRALongFromBuffer(buffer, current);
			current += sizeofLong;
		}
		return current;
	}
	/**
	 * writeToBuffer method comment.
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		
		current = Message.writeRALongToBuffer(buffer, current, (long)_processListLength);
		
		for(int i = 0; i < _processListLength; i++) {
			current = Message.writeRALongToBuffer(buffer, current, _processList[i]);
		}

		return current;
	}
}
