/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceLocation.java,v 1.5 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.local.common;


/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ResourceLocation extends CommandElement implements Constants {
	private long _port;
	private RAString _jobKey = new RAString("");
	
	public ResourceLocation() {
		super();
		_tag = RA_RESOURCE_LOCATION;
	}
	
	public int getPort() {
		return (int)_port;
	}
	
	public void setPort(int port) {
		_port = port;
	}
	
	public String getJobKey() {
		return _jobKey.getData();
	}
	
	public void setJobKey(String key) {
		_jobKey = new RAString(key);
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		int size = super.getSize();

		size += sizeofLong; //port
		size += _jobKey.getSize();

		return size;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);

		_port = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		current = Message.readRAStringFromBuffer(buffer, current, _jobKey);

		return current;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _port);
		current = Message.writeRAStringToBuffer(buffer, current, _jobKey);

		return current;
	}
}
