/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: User.java,v 1.8 2007/08/21 12:50:20 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.security;


import java.io.IOException;
import java.security.Principal;

import org.eclipse.hyades.execution.core.util.Noop;
import org.eclipse.hyades.internal.execution.local.common.AuthenticateCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.Node;

/**
 * @author rduggan
 * 
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates. To enable and disable the creation of type
 * comments go to Window>Preferences>Java>Code Generation.
 */
public class User implements Principal, CommandHandler {

	private String _name;
	private String _password;
	private Application _app; 
	private String _alias;
	private boolean _isPasswordEncrypted;

	{
		Noop.sink(this._alias, this._isPasswordEncrypted);
	}

	public static final boolean  ENABLE_PASSWORD_ENCRYPTION=false;


	public User(Application app, String name, String password) {
		_app=app;
		_name=name;
		setPassword(password);
	}

	/**
	 * @see java.security.Principal#getName()
	 */
	public String getName() {
		return _name;
	}

	public void setPassword(String password) {
		/*
		 * Try and store the passowrd in memory encrypted. If we fail to encrypt
		 * the password we will store it as is.
		 */
		try {
			if(ENABLE_PASSWORD_ENCRYPTION) {
				_isPasswordEncrypted=true;
			}
			else {
				throw new RuntimeException();
			}
		}
		catch(Exception e) {
			_password=password;
			_isPasswordEncrypted=false;
		}

	}

	public Application getApplication() {
		return _app; 
	}

	public void login(Connection connection) throws IOException{
		login(connection, this);
	}

	public void login(Connection connection, CommandHandler handler) throws IOException{

		ControlMessage message=new ControlMessage();
		AuthenticateCommand command=null;;

		String decryptedPassword=null;
		try {

			if(ENABLE_PASSWORD_ENCRYPTION) {
//				decryptedPassword=ISecurityUtilityImpl.PasswordUtil.decode(_password);
			}
			else {
				throw new RuntimeException();
			}
		}
		catch(Exception e) {
			decryptedPassword=_password;
		}
		command=new AuthenticateCommand(_name, decryptedPassword);
		message.appendCommand(command);
		connection.sendMessage(message, handler);		
	}

	public void incommingCommand(Node node, CommandElement command) {
		switch((int)command.getTag()) {
			case (int)Constants.RA_AUTHENTICATION_SUCCESSFUL:
				break;
			case (int)Constants.RA_AUTHENTICATION_FAILED:
				break;
		}
	}
}
