/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileTransferTest.java,v 1.5 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.execution.local;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;

import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.util.Noop;
import org.eclipse.hyades.execution.local.NodeImpl;

/**
 * @author Giridhar.S To change the template for this generated type comment go
 *         to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class FileTransferTest {

	public static void delete(IFileManager m, String file) {
		try {
			m.deleteFile(file);
		} catch (IOException e) {
		}
	}

	public static void get(IFileManager m, String localFile, String remoteFile) {
		try {
			m.getFile(localFile, remoteFile);
		} catch (IOException e) {
		}
	}

	public static void main(String[] args) {

		INode node = new NodeImpl("win-pagarwal01");//$NON-NLS-1$

		ISession session = null;

		try {
			session = node.connect("10002", null);//$NON-NLS-1$
		} catch (UnknownHostException e) {
		} catch (UnknownDaemonException e) {
		} catch (DaemonConnectException e) {
		}

		IFileManager manager = ((NodeImpl) node).getFileManager();

		get(manager, "C:\\temp1.zip", "C:\\temp.zip");//$NON-NLS-1$//$NON-NLS-2$
		put(manager, "C:\\trace.trcxml", "C:\\trace1.trcxml");//$NON-NLS-1$//$NON-NLS-2$
		delete(manager, "C:\\abcd.trcxml");//$NON-NLS-1$

		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
		Noop.sink(reader);

		/*
		 * try { reader.readLine(); } catch (IOException e1) { }
		 */

		session.release();
	}

	public static void put(IFileManager m, String localFile, String remoteFile) {
		try {
			m.putFile(localFile, remoteFile);
		} catch (IOException e) {
		}
	}
}
