
/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Test.java,v 1.4 2008/03/20 18:49:49 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.execution.local;


import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.execution.local.internal.resources.LocalResourceBundle;
import org.eclipse.osgi.util.NLS;

public class Test {


	public void run() {
		/* Create our session */
		//INode node=new NodeImpl("rduggan");
		INode node=new NodeImpl("win-pagarwal01");//$NON-NLS-1$
		ISession session=null;
		try {
			session=node.connect("10002", null);//$NON-NLS-1$
			
			IFileManager manager=((NodeImpl)node).getFileManager();
			//manager.getFile("c:\\temp\\transfer.out", "c:\\temp\\regex1.adapter");
			manager.getFile("c:\\temp\\first.trcxml", "c:\\temp\\second.trcxml");//$NON-NLS-1$//$NON-NLS-2$
			System.out.println(LocalResourceBundle.Test_FILE_TRANSFER_COMPLETE_);
			
		}
		catch(Exception e) {
			System.out.println(NLS.bind(LocalResourceBundle.Test_ERROR_CREATING_SESSION_, e.getMessage()));
			e.printStackTrace();
			return;
		}
		
		try {
		
			// Get our factory 
			IExecutionComponentFactory factory=ExecutionComponentFactoryImpl.getInstance(session);
			
			// Configure our factory to use the proper types 
			factory.addExecutionComponent("ENVIRONMENT", "org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl");//$NON-NLS-1$//$NON-NLS-2$
			factory.addStub("ENVIRONMENT", "org.eclipse.hyades.execution.local.ExecutionEnvironmentStub");//$NON-NLS-1$//$NON-NLS-2$
			factory.addSkeleton("ENVIRONMENT", "org.eclipse.hyades.execution.remote.ExecutionEnvironmentSkeleton");//$NON-NLS-1$//$NON-NLS-2$
			
			factory.addExecutionComponent("EXECUTOR", "org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl");//$NON-NLS-1$//$NON-NLS-2$
			factory.addStub("EXECUTOR", "org.eclipse.hyades.execution.local.ExecutorStub");//$NON-NLS-1$//$NON-NLS-2$
			factory.addSkeleton("EXECUTOR", "org.eclipse.hyades.execution.remote.ExecutorSkeleton");//$NON-NLS-1$//$NON-NLS-2$

			
			// create our environment 
			IExecutionEnvironment exeEnvironment =(IExecutionEnvironment)factory.createExecutionComponentByType("ENVIRONMENT");//$NON-NLS-1$
			
			session.addChild(exeEnvironment);
			
			OrderedPropertyImpl property=new OrderedPropertyImpl();
			property.setName("PATH");//$NON-NLS-1$
			property.appendValue("d:\\temp");//$NON-NLS-1$
			exeEnvironment.addEnv(property);
			
			
			// create our executor 
			IExecutor executor =(IExecutor)factory.createExecutionComponentByType("EXECUTOR");//$NON-NLS-1$
			
			// Add an executor to the environment 
			exeEnvironment.addChild(executor);
			
			//executor.setExecutableObject(null);
			executor.launch();
		}
		catch(ClassNotFoundException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		finally {
			session.release();
		}
	}

	public static void main(String[] args) {
		Test test= new Test();
		test.run();
	}
}
