/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutableObjectSkeleton.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 *
 * Contributors:
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutor;

/**
 * 
 */
public class ExecutableObjectSkeleton
	extends RemoteObjectSkeleton
	implements IExecutableObject {
		
	public void init() {
		((IExecutableObject)delegate).init();
	}
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getName()
	 */
	public String getName() {
		return ((IExecutableObject)delegate).getName();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#setExecutor(org.eclipse.hyades.execution.core.IExecutor)
	 */
	public void setExecutor(IExecutor executor) {
		((IExecutableObject)delegate).setExecutor(executor);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getExecutor()
	 */
	public IExecutor getExecutor() {
		return ((IExecutableObject)delegate).getExecutor();
	}

}
