/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionComponentSkeleton.java,v 1.3 2008/03/20 18:49:52 dmorris Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.remote;


import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.MessageDeliveryException;
import org.eclipse.hyades.execution.core.MessageProcessingException;
import org.eclipse.hyades.execution.remote.internal.resources.RemoteResourceBundle;

/**
 * This is the parent of the hierarchy of <code>IExecutionComponent<code> skeletons
 * -- objects that handle the remote end of remote invocation semantics for their
 * delegates, which are <code>IExecutionComponent</code> instances.
 */
public abstract class ExecutionComponentSkeleton
	extends RemoteObjectSkeleton
	implements IExecutionComponent {

	public ExecutionComponentSkeleton() {}

	/**
	 * Create an <code>ExecutionComponentSkeleton</code> associating the instance
	 * (and hence the targtet object) with the specified unique id and delegate
	 * object.
	 * 
	 * @param delegate an <code>IExecutionComponent</code>
	 * @param id
	 */
	public ExecutionComponentSkeleton(IExecutionComponent delegate, Integer id) {
		super(id);
		this.delegate=delegate;
	}
	
	public void init() {
		((IExecutionComponent)delegate).init();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getName()
	 */
	public String getName() {
		return ((IExecutionComponent)delegate).getName();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getId()
	 */
	public String getId() {
		return ((IExecutionComponent)delegate).getId();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getType()
	 */
	public String getType() {
		return ((IExecutionComponent)delegate).getType();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getVersion()
	 */
	public String getVersion() {
		return ((IExecutionComponent)delegate).getVersion();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getParent()
	 */
	public IExecutionComponent getParent() {
		return ((IExecutionComponent)delegate).getParent();
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#setParent(org.eclipse.hyades.execution.core.IExecutionComponent)
	 */
	public void setParent(IExecutionComponent parent) {
		((IExecutionComponent)delegate).setParent(parent);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getChildren()
	 */
	public IExecutionComponent[] getChildren() {
		return ((IExecutionComponent)delegate).getChildren();
	}


	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getChildById(java.lang.String)
	 */
	public IExecutionComponent getChildById(String id) {
		return ((IExecutionComponent)delegate).getChildById(id);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getChildByName(java.lang.String)
	 */
	public IExecutionComponent getChildByName(String name) {
		return ((IExecutionComponent)delegate).getChildByName(name);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#addChild(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void addChild(IExecutionComponent child) {
		((IExecutionComponent)delegate).addChild(child);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getNode()
	 */
	public INode getNode() {
		return ((IExecutionComponent)delegate).getNode();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getState()
	 */
	public int getState() {
		return ((IExecutionComponent)delegate).getState();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#addExecutionComponentStateChangeListener(org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener)
	 */
	public void addExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
		((IExecutionComponent)delegate).addExecutionComponentStateChangeListener(listener);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#removeExecutionComponentStateChangeListener(org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener)
	 */
	public void removeExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
		((IExecutionComponent)delegate).removeExecutionComponentStateChangeListener(listener);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#fireStateChangeEvent(org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent)
	 */
	public void fireStateChangeEvent(ExecutionComponentStateChangeEvent event) {
		((IExecutionComponent)delegate).fireStateChangeEvent(event);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#handleMessage(org.eclipse.hyades.execution.core.IControlMessage)
	 */
	public void handleMessage(IControlMessage message) throws MessageProcessingException {
		((IExecutionComponent)delegate).handleMessage(message);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#sendMessage(org.eclipse.hyades.execution.core.IControlMessage)
	 */
	public void sendMessage(IControlMessage message) throws MessageDeliveryException {
		throw new MessageDeliveryException(RemoteResourceBundle.ExecutionComponentSkeleton_CAN_NOT_SEND_MESSAGE_);
	}
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#removeChild(org.eclipse.hyades.execution.core.IExecutionComponent)
	 */
	public void removeChild(IExecutionComponent child) {
		((IExecutionComponent)delegate).removeChild(child);
	}

}
