/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionEnvironmentSkeleton.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ExecutionEnvironmentSkeleton extends ExecutionComponentSkeleton implements IExecutionEnvironment {


	public ExecutionEnvironmentSkeleton() {
		super();
	}

	public ExecutionEnvironmentSkeleton(IExecutionComponent delegate, Integer id) {
		super(delegate, id);
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#getEnv()
	 */
	public IOrderedProperty[] getEnv() throws ExecutionComponentStateException {
		return ((IExecutionEnvironment)delegate).getEnv();
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#getEnvByName(java.lang.String)
	 */
	public IOrderedProperty getEnvByName(String name) throws ExecutionComponentStateException {
		return ((IExecutionEnvironment)delegate).getEnvByName(name);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#setEnv(org.eclipse.hyades.execution.core.IOrderedProperty[])
	 */
	public void setEnv(IOrderedProperty[] env) throws ExecutionComponentStateException {
		((IExecutionEnvironment)delegate).setEnv(env);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#addEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void addEnv(IOrderedProperty env) throws ExecutionComponentStateException {
		((IExecutionEnvironment)delegate).addEnv(env);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#removeProperty(java.lang.String)
	 */
	public IOrderedProperty removeProperty(String name)	throws ExecutionComponentStateException {
		return ((IExecutionEnvironment)delegate).removeProperty(name);
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#setEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void setEnv(IOrderedProperty env) throws ExecutionComponentStateException {
		((IExecutionEnvironment)delegate).setEnv(env);
	}
}
