/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentConfiguration.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.remote;

import java.util.Vector;

public class AgentConfiguration {

    protected String _agentName = null;
    protected Vector _entries = new Vector();

    public AgentConfiguration() {
        super();
    }

    public void addEntry(AgentConfigurationEntry entry) {
        _entries.addElement(entry);
    }

    public void clear() {
        _entries.clear();
    }

    public String getAgentName() {
        return _agentName;
    }

    public AgentConfigurationEntry getEntryAt(int offset) {
        return (AgentConfigurationEntry) _entries.elementAt(offset);
    }

    public void setAgentName(String name) {
        _agentName = name;
    }

    public int size() {
        return _entries.size();
    }

    /**
     *  Removes an entry from this configuration.
     */
    public boolean removeEntry(AgentConfigurationEntry entry) {
        return _entries.removeElement(entry);
    }
}
