/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentConfigurationEntry.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.remote;

/**
 * Insert the type's description here.
 * Creation date: (11/9/00 8:15:42 AM)
 * @author:
 */
public class AgentConfigurationEntry {
    protected String _type = null;
    protected String _name = null;
    protected String _value = null;
    protected boolean _enabled = true;
    /**
     * AgentConfigurationEntry constructor comment.
     */
    public AgentConfigurationEntry() {
        super();
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/9/00 8:16:49 AM)
     * @return java.lang.String
     */
    public java.lang.String getName() {
        return _name;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/9/00 8:16:49 AM)
     * @return java.lang.String
     */
    public java.lang.String getType() {
        return _type;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/9/00 8:16:49 AM)
     * @return java.lang.String
     */
    public java.lang.String getValue() {
        return _value;
    }

    public boolean isEnabled() {
        return _enabled;
    }

    /**
     * Insert the method's description here.
     * Creation date: (11/9/00 8:16:49 AM)
     * @param new_name java.lang.String
     */
    public void setName(java.lang.String new_name) {
        _name = new_name;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/9/00 8:16:49 AM)
     * @param new_type java.lang.String
     */
    public void setType(java.lang.String new_type) {
        _type = new_type;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/9/00 8:16:49 AM)
     * @param new_value java.lang.String
     */
    public void setValue(java.lang.String new_value) {
        _value = new_value;
    }

    public void setEnabled(boolean enabled) {
        _enabled = enabled;
    }

    public boolean equals(AgentConfigurationEntry rhs) {
        String rhsType = rhs.getType();
        String rhsName = rhs.getName();
        String rhsValue = rhs.getValue();

        /* Compare each of the strings.  If anything is null then they are invalid entries and return not equal */
        try {
            /* Check if all the strings are the same */
            if (!(rhsType.equals(_type) && rhsName.equals(_name) && rhsValue.equals(_value))) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }

        return true;
    }

}
