/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: Messages.java,v 1.5 2008/04/28 15:45:40 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.automation.client.adapters.shell;

import org.eclipse.hyades.automation.client.internal.resources.AutomationClientResourceBundle;

/**
 * Message properties class for retrieving resource strings from resource
 * bundle. Currently, the shell automation client adapter has messages and
 * parameter names that are not localized (although this will be planned as
 * appropriate in future releases).
 * </p>
 * 
 * 
 * @author     Duwayne J. Morris
 * @author     Scott E. Schneider
 * @author     Paul E. Slauenwhite
 * @version    April 25, 2008
 * @since      October 7, 2005
 * @deprecated As of TPTP 4.5.0, use {@link AutomationClientResourceBundle}.
 */
class Messages {

	/**
	 * Retrieves a string with the given key
	 * 
	 * @param key
	 *            the resource string key that associates with a message in the
	 *            resource bundle
	 * @return the message or string related to the given key
	 */
	public static String getString(String key) {
		return (AutomationClientResourceBundle.getString(key));
	}

	/**
	 * Limit instantiation so class is used at the class-level only
	 */
	private Messages() {
	}

}
