/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReusableThreadPool.java,v 1.1 2005/10/07 14:49:18 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.automation.core.utils;

/**
 * The reusable thread pool; allows for the acquisition of a usable thread from
 * the pool and the release of that thread once it has been used by a client
 * such as the progressive task class.
 * 
 * If the release thread is not called when done using a reusable thread, the
 * thread cannot be properly garbage collected or put back into the pool as
 * necessary. The reusable thread pool is currently implemented to create a new
 * thread on the acquire thread method and kill the thread on the release thread
 * method.
 * 
 * In the future different thread pool strategies can be implemented that
 * implement more than just a degenerate case of a thread pool. The degenerate
 * case now implemented is where the pool size is not limited and there is no
 * reuse of the reusable thread once released.
 * 
 * @author Scott E. Schneider
 */

class ReusableThreadPool {

    ReusableThread acquireThread() {
        return new ReusableThread();
    }

    void releaseThread(ReusableThread thread) {
        thread.kill();
    }

}