/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IAutomationServer.java,v 1.1 2006/03/16 19:34:21 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.core;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Automation server interface, this is a remote interface that implements the
 * standard platform runnable interface
 * 
 * @author Scott E. Schneider
 */
public interface IAutomationServer extends Remote {
	/**
	 * This method duplicates the signature of the same method in the platform
	 * runnable interface but this one is remotable
	 * 
	 * @param args
	 *            the args to pass to the automation server
	 * @return the return object
	 * 
	 * @throws RemoteException
	 *             any remoting issues will trigger a remote exception to be
	 *             thrown
	 */
	public Object run(Object args) throws RemoteException;
}
