/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractService.java,v 1.4 2005/10/14 23:31:20 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.server;

import org.eclipse.hyades.automation.core.utils.ProgressiveTask.Synchronicity;

/**
 * Abstract class for published services, service implementations will extend
 * from this class, either directly or indirectly through additional value-added
 * abstract service related classes (such as the ones referred to below in the
 * reference section)
 * 
 * @see org.eclipse.hyades.automation.server.AbstractRelaunchableService
 * @see org.eclipse.hyades.automation.server.AbstractWorkspaceSensitiveService
 * 
 * @author Scott E. Schneider
 */
public abstract class AbstractService extends org.eclipse.hyades.automation.core.AbstractService {

	/**
	 * Default constructor invokes up hierarchy for any initialization required
	 */
	protected AbstractService() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service#execute(org.eclipse.hyades.automation.core.Service.Synchronicity)
	 */
	public Object execute(Synchronicity synchronicity) {
		return this.execute();
	}

}
