/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExtensionsImages.java,v 1.4 2009/03/24 16:12:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.extensions;

import java.net.URL;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * <p>Test UI Extensions image manager.</p>
 * 
 * <p><b>Note:</b>This class is not intended to be extended 
 * or used externally, and images are subject to be changed 
 * without notice.</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul E. Slauenwhite
 * @version March 24, 2009
 * @since   May 14, 2006
 */
public class ExtensionsImages extends ImageManager {

    /**
     * ExtensionImages' singleton.
     */
    public static final ExtensionsImages INSTANCE = new ExtensionsImages();
    
    /**
	 * No-argument constructor.
	 */
	public ExtensionsImages(){
		
		try	{
			initialize(new URL(ExtensionsPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), ExtensionsPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			ExtensionsPlugin.logError(e);
		}	
	}
    
    public static final String IMG_BUG = "bug.gif"; //$NON-NLS-1$
    public static final String IMG_REMOVE_BUG = "remove_bug.gif"; //$NON-NLS-1$
    
    protected void addImages() {

        add(T_OBJ, IMG_BUG);
        add(T_OBJ, IMG_REMOVE_BUG);
    }
}
