/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExtensionsPlugin.java,v 1.7 2009/03/24 16:12:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.extensions;

import java.util.MissingResourceException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * <p>Test UI Extensions plug-in class.</p>
 * 
 * <p><b>Note:</b> This class should not be used outside 
 * the context of Eclipse.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version March 24, 2009
 * @since   May 14, 2006
 */
public class ExtensionsPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.hyades.test.ui.extensions"; //$NON-NLS-1$

	// The shared instance
	private static ExtensionsPlugin plugin;
	
	/**
	 * The constructor
	 */
	public ExtensionsPlugin() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
		savePluginPreferences();
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static ExtensionsPlugin getDefault() {
		return plugin;
	}
	
	/**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.ui.extensions.internal.resources.ExtensionsPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key)
    {
    	        
    	try {
    		return (Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID)).getString(key));
        } 
    	catch (MissingResourceException x) {
        	return key;
        }
    }
    
	/**
	 * Logs an error described by a throwable.
	 * 
	 * <p>This method should be used whenever a class in this instance
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param throwable
	 */
	public static void logError(Throwable throwable)
	{
		Status status = new Status(IStatus.ERROR, PLUGIN_ID, 0, throwable.toString(), throwable);
		plugin.getLog().log(status);
	}
	
	/**
	 * Logs an error described by a text.
	 * 
	 * <p>This method should be whenever a class in this instance
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param text
	 */
	public static void logError(String text)
	{
		logError(new Throwable(text));
	}
	
	/**
	 * Logs an information described by a text.
	 * 
	 * <p>This method should be whenever a class in this instance
	 * has to log an information since it adheres to the global logging
	 * strategy.
	 * 
	 * @param text
	 */
	public static void logInfo(String text)
	{
		Status status = new Status(IStatus.INFO, PLUGIN_ID, 0, text, new Throwable(text));
		plugin.getLog().log(status);
	}
	// TestGen info
	public static String getPreference(String key)
	{
		return getDefault().getPreferenceStore().getString(key);
	}	
	
	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#initializeDefaultPreferences(org.eclipse.jface.preference.IPreferenceStore)
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store)
	{        
        //Test log viewer default preferences
        store.setDefault(ExtensionsConstants.BUGZILLA_SUBMIT_URL, "https://bugs.eclipse.org/bugs/enter_bug.cgi"); //$NON-NLS-1$
        store.setDefault(ExtensionsConstants.BUGZILLA_SEARCH_URL, "https://bugs.eclipse.org/bugs/query.cgi"); //$NON-NLS-1$
        store.setDefault(ExtensionsConstants.BUGZILLA_OPEN_URL, "https://bugs.eclipse.org/bugs/show_bug.cgi?id="); //$NON-NLS-1$
	}
}
