/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogViewerPreferencePage.java,v 1.8 2009/07/29 11:31:08 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.extensions.internal;

import java.net.URL;
import java.util.Arrays;

import org.eclipse.hyades.test.ui.extensions.ExtensionsConstants;
import org.eclipse.hyades.test.ui.extensions.ExtensionsPlugin;
import org.eclipse.hyades.test.ui.extensions.internal.resources.ExtensionsPluginResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * <p>Test log viewer preference page.</p>
 * 
 * 
 * @author      Bianca Xue Jiang
 * @author      Paul E. Slauenwhite
 * @version     July 29, 2009
 * @since       April 26, 2007
 */
public class TestLogViewerPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
	
	public TestLogViewerPreferencePage(){
		
		super(FieldEditorPreferencePage.GRID);
		
		setPreferenceStore(ExtensionsPlugin.getDefault().getPreferenceStore());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		//No-operation.
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	protected void createFieldEditors() {
		
		GridLayout gridLayout = new GridLayout(1, true);		
		gridLayout.marginWidth = gridLayout.marginHeight = 5;
		gridLayout.horizontalSpacing = gridLayout.verticalSpacing = 5;
		
		Group group = new Group(getFieldEditorParent(), SWT.SHADOW_ETCHED_IN);
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		group.setLayout(gridLayout);
		group.setText(ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_bugzilla); 
		
		//Work-around: Since the column sizes in the StringFieldEditor are not the same size, 
		//             different label sizes render different length text fields.  As such,
		//             the labels are padded to be the same size.
		int paddedSize = Math.max(ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_submitBugURL.length(), ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_findBugURL.length());
		paddedSize = Math.max(paddedSize, ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_openBugURL.length());
		
		//Submit:    
		Composite submitPane = new Composite(group, SWT.SHADOW_NONE);
		submitPane.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	    
		StringFieldEditor submitField = new StringFieldEditor(ExtensionsConstants.BUGZILLA_SUBMIT_URL, pad(ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_submitBugURL, paddedSize), StringFieldEditor.UNLIMITED, StringFieldEditor.VALIDATE_ON_KEY_STROKE, submitPane){
			
			 /* (non-Javadoc)
			 * @see org.eclipse.jface.preference.StringFieldEditor#doCheckState()
			 */
			protected boolean doCheckState() {
				
				try {
					new URL(getTextControl().getText().trim());
				} 
				catch (Exception e) {
					return false;
				}
				
				return true;
			}
		};
		submitField.setEmptyStringAllowed(false);
		
		addField(submitField);
		
		//Search:
		Composite searchPane = new Composite(group, SWT.SHADOW_NONE);
		searchPane.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		StringFieldEditor searchField = new StringFieldEditor(ExtensionsConstants.BUGZILLA_SEARCH_URL, pad(ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_findBugURL, paddedSize), StringFieldEditor.UNLIMITED, StringFieldEditor.VALIDATE_ON_KEY_STROKE, searchPane){
			
			 /* (non-Javadoc)
			 * @see org.eclipse.jface.preference.StringFieldEditor#doCheckState()
			 */
			protected boolean doCheckState() {
				
				try {
					new URL(getTextControl().getText().trim());
				} 
				catch (Exception e) {
					return false;
				}
				
				return true;
			}
		};
		searchField.setEmptyStringAllowed(false);
		
		addField(searchField);

		//Open:
		Composite openPane = new Composite(group, SWT.SHADOW_NONE);
		openPane.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

		StringFieldEditor openField = new StringFieldEditor(ExtensionsConstants.BUGZILLA_OPEN_URL, pad(ExtensionsPluginResourceBundle.TestLogViewerPreferencePage_openBugURL, paddedSize), StringFieldEditor.UNLIMITED, StringFieldEditor.VALIDATE_ON_KEY_STROKE, openPane){
		
			 /* (non-Javadoc)
			 * @see org.eclipse.jface.preference.StringFieldEditor#doCheckState()
			 */
			protected boolean doCheckState() {
				
				try {
					new URL(getTextControl().getText().trim());
				} 
				catch (Exception e) {
					return false;
				}
				
				return true;
			}
		};
		openField.setEmptyStringAllowed(false);
		
		addField(openField);
	}
	
	protected Control createContents(Composite parent) {
		
		Control composite = super.createContents( parent );
		Dialog.applyDialogFont( composite );
		
		return composite;
	}
	
	private String pad(String unpaddedString, int paddedSize){
		
		if((unpaddedString == null) || (unpaddedString.length() < paddedSize)){
		
			char[] spaces = new char[paddedSize - unpaddedString.length()];
		
			Arrays.fill(spaces, ' ');
		
			return (unpaddedString + new String(spaces));
		}
		
		return unpaddedString;
	}
}
