/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenLogAgentPage.java,v 1.2 2008/01/24 02:29:58 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal;

import java.util.Properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.util.HyadesExtendedResourceFactory;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.internal.dbresource.DBResourceSupportUICommon;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID olap0000 for open Logging Agent page
 */

public class OpenLogAgentPage extends WizardPage implements ModifyListener {
	protected TraceLocationUI _locationUI;

	protected Text _agentPath;

	protected Text _agentType;

	protected Text _agentName;

	protected INavigator fViewer;

	protected Combo _sign;
	
	protected Text _hour;

	protected Text _min;

	protected Text _sec;

	protected Text _micsec;

	protected Group deltaTime;

	protected Group connectionInfoGroup;

	protected int hourValue = 0;

	protected int minValue = 0;

	protected int secValue = 0;

	protected int micsecValue = 0;

	protected Properties connectionInfoProperties;

	protected DBResourceSupportUICommon connectionInfoUI;

	protected URI aURI;

	public OpenLogAgentPage(String name, INavigator viewer)

	{
		super(name);
		setTitle(LogMessages.LG_AGT);
		fViewer = viewer;

		setDescription("");
	}

	/**
	 * Insert the method's description here. Creation date: (08/22/2000 4:48:53
	 * PM)
	 * 
	 * @param show
	 *            boolean
	 */
	public void createControl(Composite parent) {
		connectionInfoProperties = null;

		Label label;

		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 5;
		content.setLayout(layout);
		GridData gd = GridUtil.createFill();
		gd.widthHint = 500;
		gd.heightHint = 400;
		content.setLayoutData(gd);

		_locationUI = new TraceLocationUI();
		_locationUI.createControl(content);
		_locationUI.setEnabled(false);

		Composite nameGrp = new Composite(content, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 5;
		nameGrp.setLayout(layout);
		nameGrp.setLayoutData(GridUtil.createHorizontalFill());

		label = new Label(nameGrp, SWT.NONE);
		label.setText(LogMessages.LG_TYPE);
		_agentType = new Text(nameGrp, SWT.BORDER);
		_agentType.setLayoutData(GridUtil.createHorizontalFill());
		_agentType.setEnabled(false);
	
		label = new Label(nameGrp, SWT.NONE);
		label.setText(LogMessages.LG_PATH);
		_agentPath = new Text(nameGrp, SWT.BORDER);
		_agentPath.setLayoutData(GridUtil.createHorizontalFill());
		_agentPath.setEnabled(false);
		
		label = new Label(nameGrp, SWT.NONE);
		label.setText(LogMessages.DISPLAY_NAME);
		_agentName = new Text(nameGrp, SWT.BORDER);
		_agentName.setLayoutData(GridUtil.createHorizontalFill());			

		deltaTime = new Group(content, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 9;
		layout.verticalSpacing = 5;
		deltaTime.setLayout(layout);
		deltaTime.setLayoutData(GridUtil.createHorizontalFill());
		deltaTime.setText(LogMessages.SNCH_NDT);

		label = new Label(deltaTime, SWT.NONE);
		label.setText(CommonUITraceMessages.DLT_TM);

		_sign = new Combo(deltaTime, SWT.BORDER | SWT.READ_ONLY);
		_sign.add("+");
		_sign.add("-");
		_sign.select(0);
		
		_hour = new Text(deltaTime, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 40;
		_hour.setLayoutData(gd);
		_hour.setTextLimit(4);
		label = new Label(deltaTime, SWT.NONE);
		label.setText(":");

		_min = new Text(deltaTime, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 30;
		_min.setLayoutData(gd);
		_min.setTextLimit(3);
		label = new Label(deltaTime, SWT.NONE);
		label.setText(":");

		_sec = new Text(deltaTime, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 30;
		_sec.setLayoutData(gd);
		_sec.setTextLimit(3);

		_micsec = new Text(deltaTime, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 70;
		_micsec.setLayoutData(gd);
		_micsec.setTextLimit(7);

		label = new Label(deltaTime, SWT.NONE);
		label.setText(CommonUITraceMessages.DLT_HMS);

		label = new Label(deltaTime, SWT.NONE);
		label.setText(CommonUITraceMessages.DLT_MIS);
		gd = new GridData();
		gd.horizontalSpan = 8;
		label.setLayoutData(gd);

		_hour.addModifyListener(this);
		_min.addModifyListener(this);
		_sec.addModifyListener(this);
		_micsec.addModifyListener(this);

		TRCAgentProxy agentProxy = ((OpenLogAgentWizard) getWizard())
				.getAgent();

		if (agentProxy != null) {
			TRCAgent agent = (TRCAgent) agentProxy.eGet(
					HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
			aURI = EcoreUtil.getURI(agent);
			if (Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap()
					.get(aURI.fileExtension()) instanceof HyadesExtendedResourceFactory) {
				connectionInfoProperties = HyadesExtendedResourceFactory
						.getPropertiesFromURI(aURI);
			}
		}

		if (aURI != null && connectionInfoProperties != null) {
			connectionInfoGroup = new Group(content, SWT.NONE);
			layout = new GridLayout();
			layout.numColumns = 2;
			connectionInfoGroup.setLayout(layout);
			connectionInfoGroup.setLayoutData(GridUtil.createHorizontalFill());
			connectionInfoGroup.setText(TraceWizardMessages.JDBC_INF);
			connectionInfoUI = new DBResourceSupportUICommon() {

				public void initializeValues(boolean defaultValue) {
					if (connectionInfoProperties != null) {
						if (connectionInfoProperties.getProperty("location") != null)
							location.setText(connectionInfoProperties
									.getProperty("location"));
						if (connectionInfoProperties.getProperty("user") != null)
							username.setText(connectionInfoProperties
									.getProperty("user"));
						if (connectionInfoProperties.getProperty("password") != null)
							password.setText(connectionInfoProperties
									.getProperty("password"));
						if (connectionInfoProperties
								.getProperty("largeResourceSupportJDBCLocation") != null)
							jdbcLocation
									.setText(connectionInfoProperties
											.getProperty("largeResourceSupportJDBCLocation"));
						if (connectionInfoProperties
								.getProperty("largeResourceSupportStoreType") != null) {
							storeType
									.add(connectionInfoProperties
											.getProperty("largeResourceSupportStoreType"));
							storeType.select(0);
						}
					}
					jdbcLocation.setEditable(false);
					jdbcBrowse.setEnabled(false);
					storeType.setEnabled(false);
				}

				public boolean storeValues() {
					if (connectionInfoProperties != null) {
						boolean save = false;
						if (location.getText() != connectionInfoProperties
								.getProperty("location")) {
							connectionInfoProperties.setProperty("location",
									location.getText());
							save = true;
						}
						if (username.getText() != connectionInfoProperties
								.getProperty("user")) {
							connectionInfoProperties.setProperty("user",
									username.getText());
							save = true;
						}
						if (password.getText() != connectionInfoProperties
								.getProperty("password")) {
							connectionInfoProperties.setProperty("password",
									password.getText());
							save = true;
						}
						if (save)
							HyadesExtendedResourceFactory.savePropertiesToURI(
									aURI, connectionInfoProperties);
					}
					return true;
				}

				protected void validateUserInput(boolean skipJDBCcheck) {

				}

				public void enableJDBCInputs() {
				}

				{
				}

				protected void enableJDBCTestConnection() {

				}

			};
			connectionInfoUI.populateGroupControl(connectionInfoGroup);
		}

		setControl(content);

		populateData();

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
				CommonUITracePlugin.PLUGIN_ID + ".olap0000");

	}

	public boolean finish() {
		TRCAgentProxy agent = ((OpenLogAgentWizard) getWizard()).getAgent();

		if (agent != null) {
			agent.setDeltaTime(getDeltaTime());
			if (connectionInfoUI != null)
				connectionInfoUI.storeValues();

			String name = agent.getName();
			String agName = HyadesUtil.codeLogAgentName(_agentType.getText().trim(),
					_agentPath.getText().trim(), _agentName.getText().trim());
			if (name != null && name.equals(agName))
				return true;

			agent.setName(agName);
			
			try{
				SaveUtil.saveResource(null, agent.eResource());
			}
			catch(Exception exc)
			{
				CommonPlugin.logError(exc);
				exc.printStackTrace();
			}
						
			ProfileEvent profEvent = TraceUIManager.getTraceUIManager().getProfileEvent();
			profEvent.setType(ProfileEvent.REFRESH_LOG_NAVIGATOR);
			profEvent.setSource(agent);
			TraceUIManager.getTraceUIManager().notifyProfileEventListener(profEvent);
		}

		return true;
	}

	public double getDeltaTime() {
		int hours = 0;
		try {
			hours = Integer.parseInt(_hour.getText());
		} catch (Exception exc) {
		}

		int min = 0;
		try {
			min = Integer.parseInt(_min.getText());
		} catch (Exception exc) {
		}
		int sec = 0;
		try {
			sec = Integer.parseInt(_sec.getText());
		} catch (Exception exc) {
		}
		int micsec = 0;
		try {
			micsec = Integer.parseInt(_micsec.getText());
		} catch (Exception exc) {
		}

//		if (hours < 0 || min < 0 || sec < 0 || micsec < 0) {
//			return -((double) (Math.abs(hours) * 3600 + Math.abs(min) * 60 + Math
//					.abs(sec)) * 1000000 + Math.abs(micsec));
//		}

		return _sign.getText().equals("+") ? ((double) hours * 3600 + min * 60 + sec) * 1000000 + micsec : 
				- (((double) hours * 3600 + min * 60 + sec) * 1000000 + micsec);

	}

	public void setDeltaTime(double delta) {

		try {
			int micsec = (int) (Math.abs(delta) % 1000000);
			double absDelta = Math.abs(delta) / 1000000;
			int hour = (int) (absDelta / 3600);
			int min = (int) ((absDelta % 3600) / 60);
			int sec = (int) ((absDelta % 3600) % 60);

			hourValue = hour;
			minValue = min;
			secValue = sec;
			micsecValue = micsec;

			if (delta >= 0) {
				_sign.select(0);
			} else {
				_sign.select(1);
			}
			_hour.setText(hourValue == 0 ? "" : String.valueOf(hourValue));
			_min.setText(minValue == 0 ? "" : String.valueOf(minValue));
			_sec.setText(secValue == 0 ? "" : String.valueOf(secValue));
			_micsec
					.setText(micsecValue == 0 ? "" : String
							.valueOf(micsecValue));
		} catch (Exception exc) {
			exc.printStackTrace();
		}
	}

	/**
	 * Insert the method's description here. Creation date: (10/05/2000 3:17:53
	 * PM)
	 */
	protected void populateData() {
		IResource sel = HyadesUtil.getSelectionFolder(fViewer);
		if (sel != null)
			_locationUI.setLocation(sel.getFullPath().toOSString());

		TRCAgentProxy agent = ((OpenLogAgentWizard) getWizard()).getAgent();

		if (agent == null)
			return;

		_locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor()
				.getName());

		String name = agent.getName();
		if(name != null)
		{
			_agentName.setText(HyadesUtil.resolveLogAgentDisplayName(name));
			_agentType.setText(HyadesUtil.resolveLogAgentType(name));
			_agentPath.setText(HyadesUtil.resolveLogAgentPath(name));
		}
		
		if (agent.getDeltaTime() != 0) {
			setDeltaTime(agent.getDeltaTime());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent event) {
		if (event.widget == _hour) {
			try {
				hourValue = Integer.parseInt(_hour.getText().trim());
				setErrorMessage(null);
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_hour.getText().trim().equals("")) {
					hourValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = LogMessages.INVDELT_FMT;
				setErrorMessage(message);
				setPageComplete(false);
			}
		} else if (event.widget == _min) {
			try {
				minValue = Integer.parseInt(_min.getText().trim());
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_min.getText().trim().equals("")) {
					minValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = LogMessages.INVDELT_FMT;
				setErrorMessage(message);

				setPageComplete(false);
			}
		} else if (event.widget == _sec) {
			try {
				secValue = Integer.parseInt(_sec.getText().trim());
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_sec.getText().trim().equals("")) {
					secValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = LogMessages.INVDELT_FMT;
				setErrorMessage(message);

				setPageComplete(false);
			}
		} else if (event.widget == _micsec) {
			try {
				micsecValue = Integer.parseInt(_micsec.getText().trim());
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_micsec.getText().trim().equals("")) {
					micsecValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = LogMessages.INVDELT_FMT;
				setErrorMessage(message);

				setPageComplete(false);
			}
		}

	}

	protected boolean canCompletePage() {

		return isHourValid() && isMinValid() && isSecValid() && isMicsecValid();

	}

	protected boolean isHourValid() {
		String hour = _hour.getText().trim();
		try {
			hourValue = Integer.parseInt(hour);
		} catch (Exception e) {
			if (!hour.equals("")) {
				setErrorMessage(LogMessages.INVDELT_FMT);
				return false;
			}
		}
		if (!hour.equals("") && hourValue < 0) {
			setErrorMessage(LogMessages.INVDELT_VAL);
			return false;
		}

		setErrorMessage(null);
		return true;
	}

	protected boolean isMinValid() {
		
		String hour = _hour.getText().trim();
		String min = _min.getText().trim();
		try {
			minValue = Integer.parseInt(min);
		} catch (Exception e) {
			if (!_min.getText().trim().equals("")) {
				setErrorMessage(LogMessages.INVDELT_FMT);
				return false;
			}

		}
		if (!hour.equals("") && hourValue != 0
				&& !(minValue >= 0 && minValue < 60)) {
			setErrorMessage(LogMessages.INVDELT_VAL);
			return false;
		}
		setErrorMessage(null);
		return true;

	}

	protected boolean isSecValid() {
		
		String hour = _hour.getText().trim();
		String min = _min.getText().trim();
		String sec = _sec.getText().trim();
		try {
			secValue = Integer.parseInt(sec);
		} catch (Exception e) {
			if (!_sec.getText().trim().equals("")) {
				setErrorMessage(LogMessages.INVDELT_FMT);
				return false;
			}

		}
		if (((!hour.equals("") && hourValue != 0) || (!min.equals("") && minValue != 0))
				&& !(secValue >= 0 && secValue < 60)) {
			setErrorMessage(LogMessages.INVDELT_VAL);
			return false;
		}
		setErrorMessage(null);
		return true;
	}

	protected boolean isMicsecValid() {
		String hour = _hour.getText().trim();
		String min = _min.getText().trim();
		String sec = _sec.getText().trim();
		String micsec = _micsec.getText().trim();
		try {
			micsecValue = Integer.parseInt(micsec);
		} catch (Exception e) {
			if (!_micsec.getText().trim().equals("")) {
				setErrorMessage(LogMessages.INVDELT_FMT);
				return false;
			}

		}
		if ((((!hour.equals("") && hourValue != 0) || (!min.equals("") && minValue != 0)) || (!sec
				.equals("") && secValue != 0))
				&& !(micsecValue >= 0 && micsecValue < 1000000)) {
			setErrorMessage(LogMessages.INVDELT_VAL);
			return false;
		}
		setErrorMessage(null);
		return true;
	}
}
