/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenLogAgentWizard.java,v 1.1 2007/11/27 04:47:11 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal;

import java.util.Iterator;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.internal.wizard.NavigatorWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.IWorkbench;

public class OpenLogAgentWizard extends NavigatorWizard  /* Ali M.: Extended Navigator wizard */
{
	protected TRCAgentProxy fAgent;

	protected INavigator fViewer;

	protected OpenLogAgentPage fPage;

	public OpenLogAgentWizard() {
		super();
	}

	public void addPages() {
		setWindowTitle(CommonUITraceMessages.PROP);
		fPage = new OpenLogAgentPage("agentPage", fViewer);
		addPage(fPage);
	}

	public TRCAgentProxy getAgent() {
		return fAgent;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		if (selection instanceof IStructuredSelection) {
			Iterator enum1 = ((IStructuredSelection) selection).iterator();
			if (enum1.hasNext()) {
				Object obj = enum1.next();
				if (obj instanceof TRCAgentProxy)
					fAgent = (TRCAgentProxy) obj;
			}
		}

		setDefaultPageImageDescriptor(CommonUITraceImages.INSTANCE.getImageDescriptor(CommonUITraceImages.IMG_UI_WZ_AGENT_PROP));
	}

	public boolean performFinish() 
	{
		return fPage.finish();
	}

	public void setViewer(INavigator viewer) 
	{
		fViewer = viewer;
	}
}
