/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EMFUtil.java,v 1.3 2007/11/27 04:47:06 apnan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.internal.util.TraceAssociationMapping;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;

/**
 * Contains generic utility methods to work with EMF objects.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class EMFUtil extends org.eclipse.tptp.platform.common.internal.util.EMFUtil
{
	public static EObject[] loadMonitorsFromResourceSet(ResourceSet resourceSet){
		List resources = resourceSet.getResources();
		int size = resources.size();
		EObject[] eObjects = new EObject[size];
		int i = 0;
		for(int idx=0; idx<size;idx++){
			Resource res = (Resource)resources.get(idx);
			List ext = res.getContents();
			Iterator iter = ext.iterator();
			while (iter.hasNext())
			{
				Object obj = iter.next();
				if (obj instanceof TRCMonitor){
					eObjects[i++] = (TRCMonitor)obj;
				}
			}			
		}
		return eObjects;
		
	}
	
	public static List getLogAgentsFromResourceSet(ResourceSet resourceSet){
		EObject[] monitors = loadMonitorsFromResourceSet(resourceSet);
		List agents = new ArrayList();
		List nodes=null;
		for (int i = 0; i < monitors.length; i++) {
			if(monitors[i]!=null){
				nodes = ((TRCMonitor)monitors[i]).getNodes();
				for (Iterator iter = nodes.iterator(); iter.hasNext();) {
					TRCNode element = (TRCNode) iter.next();
					agents.addAll(getLogAgentsFromNode(element));				
				}
			}
		}
		return agents;
	}
	
	public static List getLogAgentsFromNode(TRCNode node){
		List agents = new ArrayList();
		for (Iterator l = node.getProcessProxies().iterator(); l.hasNext();)
		{
			for (Iterator m = ((TRCProcessProxy)l.next()).getAgentProxies().iterator();	m.hasNext();) {
				TRCAgentProxy agentProxy = (TRCAgentProxy)m.next();
				if(CommonUIConstants.LOG_AGENT_TYPE.equals(agentProxy.getType()) || TraceAssociationMapping.getDefault().isViewForType(CommonUIConstants.LOG_VIEW_ID,agentProxy.getType())) {							
					agents.add(agentProxy);	
				}
			}
		}
		return agents;
	}
	
	
}
