/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonLabelProviderDelegator.java,v 1.1 2006/08/25 21:09:14 sleeloy Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.internal.util.ILabelProvider;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;

public class CommonLabelProviderDelegator implements ILabelProvider
{

	protected int layout = CommonUITraceConstants.LAYOUT_FLAT;	
	
	public CommonLabelProviderDelegator(int layout) {
		super();
		this.layout = layout;
	}

	public CommonLabelProviderDelegator() {
		super();
	}

	/**
	 * Returns the process label to be displayed. This should be a human
	 * readable, translated string that describes the process. Concrete
	 * implementations should provide the process label as desired for their
	 * purposes.
	 * 
	 * @param process
	 *            the process whose label to get.
	 * @return the process's label to be displayed to the user.
	 */
	protected String getProcessLabel(TRCProcessProxy process)
	{
		if (layout == CommonUITraceConstants.LAYOUT_FLAT)
		{
			/*
			 * Only show the process ID if it's a valid one (>0).
			 */
			if (process.getPid() > 0)
			{
				return NLS.bind(CommonUITraceMessages.PRC_LNG, new Object[] { (process.getName() == null || process.getName().length() == 0) ? CommonUITraceMessages.UNK : process.getName(), process.getNode().getName(), String.valueOf(process.getPid()) });
			} else
			{
				return NLS.bind(CommonUITraceMessages.PRC_LNG_NID, new Object[] { (process.getName() == null || process.getName().length() == 0) ? CommonUITraceMessages.UNK : process.getName(), process.getNode().getName() });
			}
		} else
		{
			// Only show the process ID if it's a valid one (>0).
			if (process.getPid() > 0)
			{
				return NLS.bind(CommonUITraceMessages.PRC_SHRT, new Object[] { (process.getName() == null || process.getName().length() == 0) ? CommonUITraceMessages.UNK : process.getName(), String.valueOf(process.getPid()) });
			} else
			{
				return process.getName();
			}
		}

	}

	/*
	 * (non-Javadoc) Method declared on ILabelProvider.
	 */
	public String getText(Object element)
	{
	    if (element instanceof TRCMonitor)
			return ((TRCMonitor) element).getName();
		else if (element instanceof TRCNode)
			return ((TRCNode) element).getName();// +":"+String.valueOf(((TRCNode)element).getPort());
		else if (element instanceof TRCProcessProxy)
			return getProcessLabel((TRCProcessProxy) element);
		else if (element instanceof TRCAgentProxy)
		{
			TRCAgentProxy a = (TRCAgentProxy) element;
			String status = HyadesUtil.getAgentLabel(a);

			return status + " " + HyadesUtil.getAgentName(a);
		}

		return "?";
	}
}
