/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultPage.java,v 1.3 2008/01/24 02:29:57 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.Page;
		
/**
 * A message page display a message in a pagebook view.
 * <p>
 * This class may be instantiated; it is not intended to be subclassed.
 * </p>
 *
 * @see org.eclipse.ui.part.PageBookView
 */
public class DefaultPage extends Page {
	protected Composite pgComp;
	protected Text msgLabel;
	protected String message = "";//$NON-NLS-1$
	
/**
 * A default page for view with no data to present.
 */
public DefaultPage() {
}

/**
 * @see org.eclipse.ui.part.IPage#createControl(org.eclipse.swt.widgets.Composite)
 */
public void createControl(Composite parent) {
	// Message in default page of Outline should have margins
	pgComp = new Composite(parent, SWT.NULL);
	pgComp.setLayoutData(GridUtil.createFill());
	pgComp.setLayout(new GridLayout());
	
	msgLabel = new Text(pgComp, SWT.MULTI | SWT.READ_ONLY |SWT.WRAP);
	msgLabel.setLayoutData(GridUtil.createFill());
	msgLabel.setText(message);
}
/** 
 * @see org.eclipse.ui.part.IPage#getControl()
 */
public Control getControl() {
	return pgComp;
}
/**
 * Sets focus to a part in the page.
 */
public void setFocus() {
	msgLabel.setFocus();
}
/**
 * Sets the message to the given string.
 *
 * @param message the message text
 */
public void setMessage(String message) {
	this.message = message;
	if (msgLabel != null)
		msgLabel.setText(message);
}

/**
 * Sets the background color of the page.
 * 
 * @param color the background color
 */
public void setBackground(Color color) {
	pgComp.setBackground(color);
	msgLabel.setBackground(color);
}
}
