/********************************************************************** 
 * Copyright (c) 2006, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;

public class ImportActionGroup extends ActionGroup
{
	protected ImportResourcesAction fImportAction;

	protected ExportResourcesAction fExportAction;

	/**
	 * Creates a new <code>ImportActionGroup</code>. The group requires that
	 * the selection provided by the part's selection provider is of type
	 * <code>org.eclipse.jface.viewers.IStructuredSelection</code>.
	 * 
	 * @param part
	 *            the view part that owns this action group
	 */
	public ImportActionGroup(INavigator part)
	{
		IWorkbenchWindow workbench = part.getSite().getWorkbenchWindow();
		fImportAction = new ImportResourcesAction(workbench);
		fExportAction = new ExportResourcesAction(workbench);
		CommonUIImages.setActionImage(CommonUIImages.INSTANCE, fImportAction, CommonUIImages.IMG_IMPORT_RESOURCE);
		CommonUIImages.setActionImage(CommonUIImages.INSTANCE, fExportAction, CommonUIImages.IMG_EXPORT_RESOURCE);
	}

	/*
	 * (non-Javadoc) Method declared in ActionGroup
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, fImportAction);
		menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, fExportAction);

		super.fillContextMenu(menu);
	}
}