/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenTraceReportAction.java,v 1.5 2008/02/28 03:12:02 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Iterator;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID owiz0000 for new wizard action
 */

public class OpenTraceReportAction extends Action {
    protected IStructuredSelection selection;

    public OpenTraceReportAction() {
        super(CommonUIMessages._148); //$NON-NLS-1$
		
		setText(CommonUIMessages._148);
		CommonUIImages.INSTANCE.setImageDescriptors(this, CommonUIImages.IMG_UI_REPORT);
		setDescription(CommonUIMessages._148);
		setToolTipText(CommonUIMessages._148);
    }

    public OpenTraceReportAction(IStructuredSelection sel) {
    	
    	this();
    	
    	selection = sel;
    	
     }
    
    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        HyadesReportWizard wizard = new HyadesReportWizard();
        wizard.init(window.getWorkbench(), selection);

        WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
        dialog.create();
        dialog.open();
        wizard.dispose();

//        selection = null;
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        selection = structuredSelection;
    }

    public boolean isApplicableForSelection() {
        if (selection == null || selection.isEmpty()) return false;       
        
        boolean applies = true;
        for (Iterator iter = ((IStructuredSelection)selection).iterator(); iter.hasNext() && applies;)
		{
			Object element = iter.next();
			applies = applies && (element instanceof TRCMonitor || element instanceof TRCNode ||
					  element instanceof TRCProcessProxy || element instanceof TRCAgentProxy);
			
		}
       
        return applies;
    }

}
