/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenWizardAction.java,v 1.5 2008/01/24 02:29:58 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.wizard.NavigatorWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.SelectionProviderAction;

/*
* CONTEXT_ID owiz0000 for new wizard action
*/

public class OpenWizardAction extends SelectionProviderAction
{
  protected Class fWizardClass;
  protected INavigator fViewer;
  
  public OpenWizardAction(INavigator viewer,
						  Class wizardclass,
						  String label)
  {
	super(viewer.getViewer(), label);
	fWizardClass = wizardclass;
	fViewer = viewer;

  }  
  public void run()
  {
	try
	{
	  IWorkbench workbench = CommonUITracePlugin.getDefault().getWorkbench();	  
		
	  NavigatorWizard wizard = (NavigatorWizard) fWizardClass.newInstance();
	  WizardDialog dialog = new WizardDialog(fViewer.getViewSite().getShell(), wizard);

	  IStructuredSelection selection = (IStructuredSelection) fViewer.getViewer().getSelection();
	  if (wizard instanceof INewWizard)
	  {
		((INewWizard) wizard).init(workbench, selection);
	  }
	  
	  wizard.setViewer(fViewer);	
	  dialog.open();
	  
	  ProfileEvent event = TraceUIManager.getTraceUIManager().getRefreshViewEvent(selection);
	  TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
	}
	catch (IllegalAccessException e)
	{ 
	  e.printStackTrace();
	}
	catch (InstantiationException e)
	{
	  e.printStackTrace();
	}
  } 
  
  public void dispose() {
		
	  super.dispose();
		
	  fViewer = null;
	  fWizardClass = null;
  }

}
