/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RefreshViewsActionDelegate.java,v 1.3 2007/11/27 04:47:10 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.actions.AbstractProfileActionDelegate;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.tptp.platform.common.ui.trace.internal.actions.AbstractListenerActionDelegate;

/*
* CONTEXT_ID rfrv0000 for refresh views action
*/
public class RefreshViewsActionDelegate extends AbstractListenerActionDelegate {
	
	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {

		if (object == null)
			return;

		if (object instanceof INavigatorItem) {
			object = ((INavigatorItem)object).getData();
		}
		
		//we could also have other objects in the navigators, not only EObjects 
		/*if (!(object instanceof EObject)) {
			return;
		}*/
		
		INavigator fViewer = (INavigator)getView();
		if (fViewer == null) {
			MessageDialog.openInformation(
				CommonUITracePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
				"title",
				"Action not available in current context");
			return;
		}

		run(object, fViewer);
	}
		
	public void run(Object object, INavigator fViewer) {
		ProfileEvent event = TraceUIManager.getTraceUIManager().getRefreshViewEvent(object);
		TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);           
	}
	
	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {
		return true;
	}

	public void dispose()
	{
		super.dispose();
	}
	
}
