/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SaveAction.java,v 1.6 2009/08/05 22:07:22 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.internal.util.SaveUtil;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
* CONTEXT_ID save0000 for save to local action
*/
public class SaveAction extends SelectionProviderAction
	implements ISelectionChangedListener, IRunnableWithProgress {
	
	protected INavigator fViewer;
	protected Object[] fSelections;

	public SaveAction(INavigator viewer) {
		super(viewer.getViewer(), CommonUITraceMessages.SAVE);
		setDescription(Action.removeMnemonics(CommonUITraceMessages.SAVE));
		CommonUIImages.setActionImage(CommonUITraceImages.INSTANCE, this, CommonUITraceImages.IMG_SAVE);
		fViewer = viewer;

		PlatformUI.getWorkbench().getHelpSystem().setHelp(
			this,
			CommonUITracePlugin.PLUGIN_ID + ".save0000");

	}
	public void run() {
		String msg = "";
		
		ISelection sel =
			(ISelection) getSelection();
		if(!(sel instanceof IStructuredSelection))
			return;
		
		if(sel != null && !sel.isEmpty())
		{
			if(((IStructuredSelection)sel).size()==1 && ((IStructuredSelection)sel).getFirstElement()!=null && ((IStructuredSelection)sel).getFirstElement() instanceof IProject){
				msg = CommonUITraceMessages.SAVE_PQ;
			}else{
				msg = CommonUITraceMessages.SAVE_RQ;
			}
		}

		if (!MessageDialog
			.openQuestion(
				Display.getCurrent().getActiveShell(),
				CommonUITraceMessages.TRC_MSGT,
				msg))
			return;
		
		finishSaving(((IStructuredSelection)sel).toArray());
		
	}
	
	public void finishSaving(Object[] selections){		

		fSelections = selections;
		try {
			new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(
				true,
				true,
				new WorkspaceModifyDelegatingOperation(this));
		} catch (InterruptedException e) {
			try {
				
				ArrayList folders = new ArrayList();
				for(int idx=0; idx<fSelections.length; idx++)
				{
					IResource res = HyadesUtil.getSelectionFolder(fSelections[idx]);
					
					if (res != null && res.exists() && !folders.contains(res))
					{
						folders.add(res);
						res.getProject().refreshLocal(
							IResource.DEPTH_INFINITE,
							null);
					}
				}
				folders.clear();
				fSelections = null;
				
				return;
				
			} catch (CoreException exc) {
				exc.printStackTrace();
			}
		} catch (InvocationTargetException e) {
			e.printStackTrace();

		}

		try {
			
			ArrayList folders = new ArrayList();
			for(int idx=0; idx<fSelections.length; idx++)
			{
				IResource res = HyadesUtil.getSelectionFolder(fSelections[idx]);
				
				if (res != null && res.exists() && !folders.contains(res))					
				{
					folders.add(res);
					res.getProject().refreshLocal(
						IResource.DEPTH_INFINITE,
						null);
				}
			}
			folders.clear();
			fSelections = null;
			
		} catch (CoreException exc) {
			exc.printStackTrace();
		}
	}

	protected INavigator getViewer(){
		return fViewer;
	}
	
		public ISelection getSelection(){
			// This implementation replaced the previous implementation
			// which called fViewer.getViewer().getSelection()
			// The implementation below was originally found in 
			// the org.eclipse.hyades.trace.ui plugin under log/ui/internal/Actions
			// Replacement needed for defect_159338
			INavigator viewer = getViewer();
			ISelection sel = viewer.getViewer().getSelection();
			List selObjects = new UniqueEList();
			if (sel != null && sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty()){
				List selection = ((IStructuredSelection)sel).toList();
				Object item =null;
				
				for (int i=0; i <selection.size(); i++){
					item = selection.get(i);
					if (item instanceof LogicalFolder)
							selObjects.addAll(((LogicalFolder)item).getChildren());
					else
						selObjects.add(item);
				}
				return new StructuredSelection(selObjects);
				}
			return sel;
		}

	
	
	public void run(IProgressMonitor monitor) {
		
		if(fSelections == null)
			return; 
		
		SaveUtil.save(Arrays.asList(fSelections), monitor, fViewer.getID());
	}
	
	public void selectionChanged(IStructuredSelection selection) {
		setEnabled(true);
	}

	public void dispose() {
		super.dispose();
		fViewer = null;
		fSelections = null;
	}
}
