/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportFilterUI.java,v 1.3 2008/01/24 02:29:56 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.internal.actions.CreateOrEditFilter;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;

public class ImportFilterUI implements SelectionListener, ModifyListener
{
	protected Label  _filterLabel;
	protected Button _editFilterButton;
	protected Button _newFilterButton;
	protected Combo  _filterListCombo;
	protected Label  _filterContextLabel;
	protected Combo  _filterContextCombo;
	protected String _scope;

	protected FilterInformationManager _fi;
	//private String _selectedFilterName;
/**
 * TraceOptionsUI constructor comment.
 */
public ImportFilterUI(String scope) {
	//TODO get the type of filter to be listed
	super();
	_scope = scope;
	
	_fi = FilterInformationManager.instance(_scope);
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent org.eclipse.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData   data;
	
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=2;
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	result.setLayoutData(data);

	Label desc = new Label(result, SWT.WRAP);
	desc.setText(CommonUITraceMessages.FILUI_DL);
	
	new Label(result, SWT.NULL);
	
	_filterLabel = new Label(result, SWT.NULL);
	_filterLabel.setText(CommonUITraceMessages.SEL_FILL);

	_filterListCombo = new Combo(result, SWT.BORDER);
	_filterListCombo.setLayoutData(GridUtil.createHorizontalFill());
	_filterListCombo.addModifyListener(this);
	
	IContextLanguage[] clangs = ContextManager.getContextLanguages();
	if (clangs!=null && clangs.length>1) 
	{
		createContextArea(clangs,result);
	}
	
	Composite buttonGroup = new Composite(result, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 2;
	buttonGroup.setLayout(layout);
	buttonGroup.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));	
	
	_newFilterButton = new Button(buttonGroup, SWT.NULL);
	_newFilterButton.setText(CommonUITraceMessages.NEWF_BTN);

	_editFilterButton = new Button(buttonGroup, SWT.NULL);
	_editFilterButton.setText(CommonUITraceMessages.EDF_BTN);

	_newFilterButton.addSelectionListener(this);
	_editFilterButton.addSelectionListener(this);
	
	initialize();	
    	
	return result;
}

protected void createContextArea(IContextLanguage[] clangs,Composite parent) 
{
	final IContextLanguage[] langs = clangs;
	
	_filterContextLabel = new Label(parent, SWT.NULL);
	_filterContextLabel.setText("Select the context to be used in filter dialog");
	
	_filterContextCombo = new Combo(parent, SWT.READ_ONLY);
	_filterContextCombo.setLayoutData(GridUtil.createHorizontalFill());
	_filterContextCombo.addSelectionListener(new SelectionListener()
		{
			public void widgetSelected(SelectionEvent e) {
				if (langs!=null && langs.length>0)
					CommonUITracePlugin.getDefault().getPreferenceStore().setValue(CommonUITraceConstants.TRACE_IMPORT_FILTER_CONTEXT,langs[_filterContextCombo.getSelectionIndex()].contextKey());
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
		}
	);	
	
	_filterContextCombo.removeAll();

	IContextLanguage language;
	String selectedContext = CommonUITracePlugin.getDefault().getPreferenceStore().getString(CommonUITraceConstants.TRACE_IMPORT_FILTER_CONTEXT);
	int selectedIndex = -1;
	
	for (int i= 0; i < clangs.length; i++)
	{
		language = clangs[i];// ContextManager.getContextLanguage(clangs[i].contextKey());
		if (language!=null)
		{
			_filterContextCombo.add(language.name());
			if (selectedContext!=null)
			{
				if (selectedContext != null && selectedContext.equals(language.contextKey()))
					selectedIndex = i;
			}
		}
	}
	
	if (selectedIndex >= 0)
		_filterContextCombo.select(selectedIndex);
}

public void initialize(){
	//TODO collect the filter from the list
	_filterListCombo.removeAll();
	
	_filterListCombo.add(CommonUITraceMessages.NOF_LBL);

	Object[] filters = _fi.getFiltersArray();
	
	for (int i = 0; i < filters.length; i++)
	{
		_filterListCombo.add(((FilterQueries)filters[i]).name());
	}
	
	_filterListCombo.setFocus();
	
	setSelectedFilterName(_fi.selectedFilterName());
}

public void widgetDefaultSelected(SelectionEvent e) {}

public void widgetSelected(SelectionEvent e)
{
	if (_scope!=null)  {
		_fi = FilterInformationManager.instance(_scope);
		
		if(e.widget == _newFilterButton)
			CreateOrEditFilter.run(_fi, null);
		else if(e.widget == _editFilterButton)
			CreateOrEditFilter.run(_fi);
		
		initialize();
	}
}

public void modifyText(ModifyEvent e) {
	// TODO Auto-generated method stub
	if (e.widget == _filterListCombo)
	{
		if (_filterListCombo.getText().equals(CommonUITraceMessages.NOF_LBL))
		{
			_editFilterButton.setEnabled(false);
			_fi.selectedFilterName(null);
		}
		else
		{
			_editFilterButton.setEnabled(true);
			if (_fi.filter(_filterListCombo.getText().trim()) != null)
				_fi.selectedFilterName(_filterListCombo.getText().trim());	
		}
	}
}

public void setSelectedFilter(String selectedFilterName, String selectedFilterType)
{
	if (selectedFilterName != null)
	{
		FilterQueries fq = _fi.filter(selectedFilterName);
		if (fq != null && fq.type().equals(selectedFilterType))
			_fi.selectedFilterName(selectedFilterName);
		else
			_fi.selectedFilterName(null);
		
	}
	else
		_fi.selectedFilterName(null);
	
	setSelectedFilterName(_fi.selectedFilterName());	
}

public String getSelectedFilterName()
{
	return _fi.selectedFilterName();
}

public String getSelectedFilterType()
{
	return _fi.selectedFilter().type();
}

public SimpleSearchQuery getSelectedFilter()
{
	return _fi.getCurrentFilter();
}

protected void setSelectedFilterName(String filterName)
{
	if (filterName != null)
		_filterListCombo.setText(filterName);
	else
		_filterListCombo.setText(CommonUITraceMessages.NOF_LBL);
}

}
