/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceHostUI.java,v 1.11 2008/04/22 20:06:07 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

 import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID hstp0001 for Hosts list in Hosts preference page
 */
/*
 * CONTEXT_ID hstp0002 for Host name/IP address entry field in Hosts preference
 * page
 */
/*
 * CONTEXT_ID hstp0003 for Delete button in host selection page
 */
/*
 * CONTEXT_ID hstp0004 for Add button in host selction page
 */
/*
 * CONTEXT_ID hstp0005 for Test Connection button in host selection page
 */
/*
 * CONTEXT_ID hstp0006 for port number entry field in host selction page
 */

public class TraceHostUI extends AbstractChangeable implements
		SelectionListener{ 
		
	protected Button _edit;
	
	protected Button _delete;

	protected Button _add;

	protected Button _testConnection;

	protected Text _host;

	protected Text _port;

	protected Table _list;

	protected WizardPage _wizardPage = null;
	
	protected boolean enabledState = true;

	class HostDialog extends Dialog implements ModifyListener {
		protected Text _host;
		protected Text _port;
		protected String hostStr;
        protected String portStr;
        protected String title;
		
		public HostDialog(String _title, String _hostStr, String _portStr) {
			super(Display.getCurrent().getActiveShell());
			title = _title;
			hostStr = _hostStr;
			portStr = _portStr;
		}
		
		protected void configureShell(Shell shell) {
			super.configureShell(shell);
			shell.setText(title);
		}

		protected Control createDialogArea(Composite parent) {
			Composite result = (Composite) super.createDialogArea(parent);

			GridLayout layout;
			GridData data;
			Label label;

			layout = new GridLayout();
			layout.numColumns = 2;
			result.setLayout(layout);
			data = GridUtil.createFill();
			data.widthHint = 400;
			result.setLayoutData(data);

			label = new Label(result, SWT.NONE);
			label.setText(CommonUITraceMessages.PHIP);
			_host = new Text(result, SWT.BORDER);
			_host.setLayoutData(GridUtil.createHorizontalFill());
			_host.addModifyListener(this);
			
			label = new Label(result, SWT.NONE);
			label.setText(CommonUITraceMessages.RAC_PT);
			_port = new Text(result, SWT.BORDER);
			_port.setLayoutData(GridUtil.createHorizontalFill());
			_port.addModifyListener(this);
			
			_port.setText(portStr!=null?portStr:String.valueOf(Constants.CTL_PORT_NUM_SERVER));
			_host.setText(hostStr!=null?hostStr:CommonUITraceConstants.LOCAL_HOST);
			_host.setFocus();
			_host.selectAll();
			
			enableField();
			
			return result;
		}

		protected void enableField() {
			if (title.equals(CommonUITraceMessages.EDT_HST)) _host.setEnabled(!_host.getText().equals(CommonUITraceConstants.LOCAL_HOST));
		}
		public void modifyText(ModifyEvent e) {
				if (getButton(IDialogConstants.OK_ID) != null)
					getButton(IDialogConstants.OK_ID).setEnabled(
						_port.getText().trim().length() > 0 && isInteger(_port.getText().trim()) && (Integer.parseInt(_port.getText().trim()) > 0) && _host.getText().trim().length() > 0);
		}
		
		public boolean isInteger(String input)
		{
			try
			{
				Integer.parseInt(input);
				return true;
			} catch (NumberFormatException nfe)
			{
				return false;
			}
		}

		protected void okPressed() {
			hostStr = _host.getText().trim();
			portStr = _port.getText().trim();
			super.okPressed();
		}
		
		/*
		 * Set the initial Ok button enablement.
		 */
		protected Control createContents(Composite parent) {
			Control result = super.createContents(parent);
			getButton(IDialogConstants.OK_ID).setEnabled(_port.getText().trim().length() > 0);
			return result;
		}

		/**
		 * @return Returns the hostStr.
		 */
		public String getHost() {
			return hostStr;
		}

		/**
		 * @return Returns the portStr.
		 */
		public String getPort() {
			return portStr;
		}
	}
	
	/**
	 * TraceOptionsUI constructor comment.
	 */
	public TraceHostUI(WizardPage wp) {
		super();
		setWizardPage(wp);
	}

	public TraceHostUI() {
		super();
	}

	/**
	 * Insert the method's description here. Creation date: (4/26/2001 4:09:19
	 * PM)
	 */
	public void addHost() {
		
		HostDialog dialog = new HostDialog(CommonUITraceMessages.ADD_HST,null,null);
		dialog.open();

		if (dialog.getReturnCode() == Window.OK) {
		
			StringBuffer buffer = new StringBuffer(dialog.getHost());
			buffer.append("[").append(dialog.getPort()).append("]");
			addHost(buffer.toString());
			
			enableButtons();
			changed();	
			setHostText();
		}
	}
	
	public void editHost() {
		int exist = -1;
		
		HostDialog dialog = new HostDialog(CommonUITraceMessages.EDT_HST,_host.getText(),_port.getText());
		dialog.open();

		if (dialog.getReturnCode() == Window.OK) {
		
			StringBuffer buffer = new StringBuffer(dialog.getHost());
			buffer.append("[").append(dialog.getPort()).append("]");
			for (int idx = 0; idx < _list.getItemCount(); idx++) {
				if (buffer.toString().equals(_list.getItem(idx).getText()))
				{	
					exist = idx;
				}
			}
			if (exist>0)
			{
				int index = _list.getSelectionIndex();
				_list.select(exist>=index?index:exist);
			}
			else
			{
				editHost(buffer.toString());
			}
			
			enableButtons();
			changed();	
			setHostText();
		}
	}
	/**
	 * Insert the method's description here. Creation date: (4/26/2001 5:17:57
	 * PM)
	 * 
	 * @param text
	 *            java.lang.String
	 */
	public void addHost(String text) {
				
		if(text == null)
			return;
		
		for (int idx = 0; idx < _list.getItemCount(); idx++) {
						
			if (text.equals(_list.getItem(idx).getText()))
			{	
				_list.select(idx);
				setHostText();
				return;
			}
		}

		TableItem item = new TableItem(_list, SWT.NONE);
		item.setText(text.trim());
		item.setImage(CommonUITraceImages.INSTANCE.getImage(CommonUITraceImages.IMG_UI_NODE));

		_list.setSelection(new TableItem[] { item });
		setHostText();
	}

	public void editHost(String text) {
		int i = _list.getSelectionIndex();
		TableItem item = _list.getItem(i);
		item.setText(text.trim());
		item.setImage(CommonUITraceImages.INSTANCE.getImage(CommonUITraceImages.IMG_UI_NODE));
	}
	
	/**
	 * Insert the method's description here. Creation date: (4/30/2001 12:10:51
	 * PM)
	 * 
	 * @param hosts
	 *            java.lang.String
	 */
	protected void addHosts(String hosts) {
		// since I only get called upon initialization
		// I will remove all the previous hosts
		// and then add these hosts
		if (hosts != null && hosts.length() > 0) {
			int idx = 0;

			while (idx != -1) {
				idx = hosts.indexOf(",");

				if (idx != -1) {
					String host = hosts.substring(0, idx);
					addHost(host);

					hosts = hosts.substring(idx + 1);

				} else {
					addHost(hosts);
				}
			}
		}

	}

	/**
	 * Insert the method's description here. Creation date: (4/26/2001 3:45:54
	 * PM)
	 * 
	 * @param parent
	 *            org.eclipse.swt.widgets.Composite
	 */
	public Composite createControl(Composite parent) {
		GridLayout layout;
		GridData data;

		Composite result = new Composite(parent, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 10;
		result.setLayout(layout);
		data = GridUtil.createFill();
		result.setLayoutData(data);

		Label desc = new Label(result, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		desc.setLayoutData(data);
		desc.setText(CommonUITraceMessages.PHNODE);

		Composite dataGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 10;
		dataGroup.setLayout(layout);
		data = GridUtil.createFill();
		dataGroup.setLayoutData(data);

		_list = new Table(dataGroup, SWT.BORDER | SWT.H_SCROLL);
		data = GridUtil.createFill();
		_list.setLayoutData(data);

		Composite bottomWidget = new Composite(dataGroup, SWT.NULL);
		data = new GridData();
		bottomWidget.setLayoutData(GridUtil.createHorizontalFill());
		layout = new GridLayout();
		layout.numColumns = 2;
		bottomWidget.setLayout(layout);

		Label hostLabel = new Label(bottomWidget, SWT.NULL);
		hostLabel.setText(CommonUITraceMessages.PHIP);

		_host = new Text(bottomWidget, SWT.BORDER);
		_host.setLayoutData(GridUtil.createHorizontalFill());

		Label portLabel = new Label(bottomWidget, SWT.NULL);
		portLabel.setText(CommonUITraceMessages.RAC_PT);

		_port = new Text(bottomWidget, SWT.BORDER);
		_port.setLayoutData(GridUtil.createHorizontalFill());
		_port.setText(String.valueOf(Constants.CTL_PORT_NUM_SERVER));

		Composite buttonWidget = new Composite(result, SWT.NULL);
		data = GridUtil.createVerticalFill();
		buttonWidget.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		buttonWidget.setLayout(layout);

		Composite buttonWidget1 = new Composite(buttonWidget, SWT.NULL);
		data = GridUtil.createFill();
		buttonWidget1.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		buttonWidget1.setLayout(layout);

		_edit = new Button(buttonWidget1, SWT.NULL);
		_edit.setLayoutData(GridUtil.createHorizontalFill());
		_edit.setText(CommonUITraceMessages.PEDT);
		
		_add = new Button(buttonWidget1, SWT.NULL);
		_add.setLayoutData(GridUtil.createHorizontalFill());
		_add.setText(CommonUITraceMessages.PADD);
		
		_delete = new Button(buttonWidget1, SWT.NULL);
		_delete.setLayoutData(GridUtil.createHorizontalFill());
		_delete.setText(CommonUITraceMessages.RMV_TXT);

		_testConnection = new Button(buttonWidget1, SWT.NULL);
		_testConnection.setLayoutData(GridUtil.createHorizontalFill());
		_testConnection.setText(CommonUITraceMessages.TST_CON);

		Label l = new Label(buttonWidget1, SWT.NULL);
		l.setLayoutData(GridUtil.createVerticalFill());

		_edit.addSelectionListener(this);
		_add.addSelectionListener(this);
		_delete.addSelectionListener(this);
		_testConnection.addSelectionListener(this);
		_list.addSelectionListener(this);

		_host.setEditable(false);
		_port.setEditable(false);

		_delete.setEnabled(false);
		_testConnection.setEnabled(false);

		initializeValues();

		PlatformUI.getWorkbench().getHelpSystem().setHelp(_list,
				CommonUITracePlugin.PLUGIN_ID + ".hstp0001");

		PlatformUI.getWorkbench().getHelpSystem().setHelp(_host,
				CommonUITracePlugin.PLUGIN_ID + ".hstp0002");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(_delete,
				CommonUITracePlugin.PLUGIN_ID + ".hstp0003");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(_add,
				CommonUITracePlugin.PLUGIN_ID + ".hstp0004");

		PlatformUI.getWorkbench().getHelpSystem().setHelp(_testConnection,
				CommonUITracePlugin.PLUGIN_ID + ".hstp0005");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(_port,
				CommonUITracePlugin.PLUGIN_ID + ".hstp0006");

		return result;
	}

	public Table getListUI() {
		return _list;
	}

	public Text getHostUI() {
		return _host;
	}

	public Text getPortUI() {
		return _port;
	}

	public Button getDeleteUI() {
		return _delete;
	}

	public Button getAddUI() {
		return _add;
	}

	public WizardPage getWizardPage() {
		return _wizardPage;
	}

	public void setWizardPage(WizardPage wp) {
		_wizardPage = wp;
	}

	/**
	 * Insert the method's description here. Creation date: (4/26/2001 4:09:39
	 * PM)
	 */
	protected void deleteHost() {
		int i = _list.getSelectionIndex();
		if (i != -1)
			_list.remove(i);
		
		_host.setText("");
		_port.setText("");
		setDefaultHost();
	}

	/**
	 * Called when the user clicks on the 'Test Connection' button in the host tab
	 */
	protected void testConnection() {
		org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
			public void run() {
				int i = _list.getSelectionIndex();
				if (i != -1) {
					TableItem tblItem = _list.getItem(i);
					String hosts = tblItem.getText();
					String port, host;
					
					if (hosts != null && !hosts.equals("")) {
						int idx = 0;
						
						idx = hosts.lastIndexOf("[");

						if (idx != -1) {
							host = hosts.substring(0, idx);
							port = hosts.substring(idx + 1,hosts.length()-1);

							HyadesUtil.testConnection(host, port, true, _list.getShell());
						}

					}
				}
		}
		});
	}

	/**
	 * Insert the method's description here. Creation date: (5/8/2001 12:30:45
	 * PM)
	 * 
	 * @return java.lang.String
	 */
	public String getHost() {
		String name = null;
		int idx = _list.getSelectionIndex();

		if (idx != -1)
			name = _list.getItem(idx).getText();
		else
			return name;

		int id = name.indexOf("[");
		if (id != -1) {
			name = name.substring(0, id);
		}

		return name;
	}

	public int getPort() {
		String port = String.valueOf(Constants.CTL_PORT_NUM_SERVER);

		int idx = _list.getSelectionIndex();
		if (idx != -1)
			port = _list.getItem(idx).getText();
		
		int id = port.indexOf("[");
		if (id != -1)
			port = port.substring(id + 1,port.length()-1);
		else
			port = String.valueOf(Constants.CTL_PORT_NUM_SERVER);
		
		try {
			return Integer.parseInt(port);
		}
		catch (NumberFormatException e) {
			return -1;
		}
	}

	public TableItem[] getHosts() {
		return _list.getItems();
	}

	/**
	 * Initializes states of the controls from the preference store.
	 */
	protected void initializeValues() {
		IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();

		String hosts = store.getString(CommonUIConstants.HOST_KEY);
		
		/* Navid Mehregani: Bugzilla 185476 */
		String modifiedHosts = hosts;
		int indexOfIAC = modifiedHosts.indexOf(CommonUITraceConstants.IAC_NAME);
		
		if (indexOfIAC != -1)
		{
			int lengthOfIAC = CommonUITraceConstants.IAC_NAME.length() + 1;
			
			/* Hosts before 'Local Direct Connection' (if any) */
			modifiedHosts = modifiedHosts.substring(0, indexOfIAC);
			
			/* Hosts after 'Local Direct Connection' (if any) */
			if ((indexOfIAC + lengthOfIAC) < (hosts.length()))
			{
				modifiedHosts = modifiedHosts + hosts.substring(indexOfIAC + lengthOfIAC).trim();
			}
			
			modifiedHosts = modifiedHosts.trim();
			if (modifiedHosts.endsWith(","))
				modifiedHosts = modifiedHosts.substring(0, modifiedHosts.length() - 1);
			
			/* Update 'hosts' and preference store */
			hosts = modifiedHosts;
			store.setValue(CommonUIConstants.HOST_KEY, modifiedHosts);
		}		
		/* End of bugzilla 185476 */
		
		addHosts(hosts);
		setDefaultHost();
		setHostText();
		
		enableButtons();
	}

	/**
	 * Insert the method's description here. Creation date: (4/30/2001 12:16:48
	 * PM)
	 */
	public void reset() {
		_list.removeAll();
	}
	/**
	 * Set the Default Selected host in Hosts List as Localhost:port (i.e. index 1 ) 
	 */
	public void setDefaultHost(){
		_list.select(1);
		setHostText();
	}
	/**
	 * Sent when default selection occurs in the control.
	 * <p>
	 * For example, on some platforms default selection occurs in a List when
	 * the user double-clicks an item or types return in a Text.
	 * </p>
	 * 
	 * @param e
	 *            an event containing information about the default selection
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
		// User double-clicked on one of the hosts. Attempt to perform
		// 'Next' if and only if this page is in a wizard.
		if (e.widget == _list && _wizardPage != null
				&& _wizardPage.getNextPage() != null)
			_wizardPage.getWizard().getContainer().showPage(
					_wizardPage.getNextPage());
	}

	protected void enableButtons() {
		
		int idx = _list.getSelectionIndex();
		String text = null;
		if(idx == -1)
		{
			_edit.setEnabled(false);
			_delete.setEnabled(false);
			_testConnection.setEnabled(false);
			return;
		}
		else
			text = ((TableItem)_list.getItem(_list.getSelectionIndex())).getText();			
		
		_edit.setEnabled(_list.getItemCount() > 1 && text != null);
		_delete.setEnabled(_list.getItemCount() > 1 && text != null && !text.equals("localhost[10002]"));
		_testConnection.setEnabled(idx != -1);
	}

	/**
	 * Sent when selection occurs in the control.
	 * <p>
	 * For example, on some platforms selection occurs in a List when the user
	 * selects an item or items.
	 * </p>
	 * 
	 * @param e
	 *            an event containing information about the selection
	 */
	public void widgetSelected(SelectionEvent e) {

		if (e.widget == _edit) {
			
			editHost();
			
			if (_wizardPage != null)
				_wizardPage.setPageComplete(_list.getSelectionIndex() != -1);
		}
		if (e.widget == _add) {
			addHost();

			if (_wizardPage != null)
				_wizardPage.setPageComplete(_list.getSelectionIndex() != -1);
			
		} else if (e.widget == _delete) {
			deleteHost();
			enableButtons();
			changed();

			if (_wizardPage != null)
				_wizardPage.setPageComplete(_list.getSelectionIndex() != -1);
			
		} else if (e.widget == _list) {
			enableButtons();
			setHostText();
			
			changed();
			if (_wizardPage != null)
				_wizardPage.setPageComplete(_list.getSelectionIndex() != -1);
		} else if (e.widget == _testConnection) {
			
			testConnection();
			enableButtons();
			_testConnection.setFocus();
		}
	}

	public void selectHost(String hostname) {
		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			if (hostname.equals(_list.getItem(idx).getText())) {
				_list.setSelection(idx);
				enableButtons();				
				return;
			}
		}
		
		enableButtons();
	}
	
	public void setEnabled(boolean state){
		_list.setEnabled(state);
		_add.setEnabled(state);
		_delete.setEnabled(state);
		_edit.setEnabled(state);
		_port.setEnabled(state);
		_testConnection.setEnabled(state);
		_host.setEnabled(state);
		enabledState = state;
	}
	
	public boolean isEnabled(){
		return enabledState;  
	}
	
	protected void setHostText()
	{
		TableItem[] selected = _list.getSelection();				
		if(selected.length > 0)
		{
			String text = selected[0].getText();
			
			int idx=text.lastIndexOf("[");
			if(idx != -1)
			{
				_host.setText(text.substring(0, idx));
				
				if(idx<text.length()-1)
				{
					_port.setText(text.substring(idx+1,text.length()-1));
				}
				else
					_port.setText("");
			}
		
		}
		else
		{
			_host.setText("");
			_port.setText("");
		}

	}
}
