/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceLocationUI.java,v 1.3 2008/01/24 02:29:56 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

/*
* CONTEXT_ID tloc0001 for location entry field from trace location
*/
/*
* CONTEXT_ID tloc0002 for browse location button from trace location
*/
/*
* CONTEXT_ID tloc0003 for monitor entry field from trace location
*/
/*
* CONTEXT_ID tloc0004 for browse monitor button from trace location
*/

public class TraceLocationUI extends AbstractChangeable implements SelectionListener
{
	protected Button _browseLocation;
	protected Text   _location;
	protected Text   _monitor;
	protected Button _browseMonitor;
	protected Label  _locationLabel;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceLocationUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent org.eclipse.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData   data;
	
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 3;
	layout.verticalSpacing=2;
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	result.setLayoutData(data);

	Listener modifyListener = new Listener() {
		public void handleEvent(Event event) {
			changed();
		}
	};
	
	_locationLabel = new Label(result, SWT.NULL);
	_locationLabel.setText(CommonUITraceMessages.TRACE_LOC);

	_location = new Text(result, SWT.BORDER);
	_location.setLayoutData(GridUtil.createHorizontalFill());
	_location.addListener(SWT.Modify, modifyListener);
	
	_browseLocation = new Button(result, SWT.NULL);
	_browseLocation.setText(CommonUITraceMessages.BROWSE);
	
	Label desc = new Label(result, SWT.NULL);
	desc.setText(CommonUITraceMessages.MON_LOC);

	_monitor = new Text(result, SWT.BORDER);
	_monitor.setLayoutData(GridUtil.createHorizontalFill());
	_monitor.addListener(SWT.Modify, modifyListener);
	
	_browseMonitor = new Button(result, SWT.NULL);
	_browseMonitor.setText(CommonUITraceMessages.BROWSE1);
		
	_browseLocation.addSelectionListener(this);
	_browseMonitor.addSelectionListener(this);	
	
	_location.setFocus();
	
	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		_location,
		CommonUITracePlugin.PLUGIN_ID +".tloc0001");
	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		_browseLocation,
		CommonUITracePlugin.PLUGIN_ID+".tloc0002");
	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		_monitor,
		CommonUITracePlugin.PLUGIN_ID+".tloc0003");
	
	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		_browseMonitor,
		CommonUITracePlugin.PLUGIN_ID+".tloc0004");
	
	initialize();	
    	
	return result;
}

public void initialize(){
	IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();	
	
	_location.setText(store.getString(CommonUITraceConstants.TRACE_PROJECT_NAME));
	_monitor.setText(store.getString(CommonUITraceConstants.TRACE_MONITOR_NAME));	

}

public Label getLocationLabel() {
	return _locationLabel;
}

/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 12:07:29 PM)
 * @return java.lang.String
 */
public Text getLocation() {
	return _location;
}
/**
 * Insert the method's description here.
 * Creation date: (8/8/2001 3:15:44 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getMonitor() {
	return _monitor;
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 1:56:12 PM)
 * @param enable boolean
 */
public void setEnabled(boolean enable)
{
	_location.setEnabled(enable);
	_browseLocation.setEnabled(enable);

	_monitor.setEnabled(enable);
	_browseMonitor.setEnabled(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (9/26/2001 1:54:33 PM)
 * @param enable boolean
 */
public void setEnabledBrowse(boolean enable) {

	_browseLocation.setEnabled(enable);
	_browseMonitor.setEnabled(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (9/26/2001 1:52:48 PM)
 * @param enabled boolean
 */
public void setEnabledLocation(boolean enable) {

	_location.setEnabled(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 12:08:12 PM)
 * @param location java.lang.String
 */
public void setLocation(String location)
{
	_location.setText(location);
}
/**
 * Insert the method's description here.
 * Creation date: (8/8/2001 3:16:11 PM)
 * @param text java.lang.String
 */
public void setMonitor(String text)
{
	_monitor.setText(text);
}
/**
 * Insert the method's description here.
 * Creation date: (8/8/2001 3:43:13 PM)
 */
protected void showMonitorsDialog()
{
	MonitorSelectionDialog dialog = new MonitorSelectionDialog(
		   CommonUITracePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 
		   CommonUITraceMessages.RES_DLGM);

	if (dialog.open() == MonitorSelectionDialog.OK)
	{

		Object[] result = dialog.getResult();
		if (result != null && result.length == 1 && result[0] != null)
		{
			IPath path = (IPath) result[0];
			_monitor.setText(path.lastSegment());
			_location.setText(path.uptoSegment(path.segmentCount()-1).toOSString());
			
			_monitor.setFocus();	
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 12:06:04 PM)
 */
protected void showResourceDialog()
{
	IPath path = new Path(_location.getText().trim());
	IResource res = CommonPlugin.getRoot().findMember(path);
	IContainer cont = null;
	
	if(res != null && res.exists() && res instanceof IContainer)
	   cont = (IContainer)res;
	
	ContainerSelectionDialog dialog = new ContainerSelectionDialog(CommonUITracePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), cont, true, CommonUITraceMessages.RES_DLGM);

	if (dialog.open() == ContainerSelectionDialog.OK)
	{
		Object[] result = dialog.getResult();
		if (result != null && result.length == 1 && result[0] != null)
		{
			_location.setText(((IPath)result[0]).toOSString());		
		}
		
		_location.setFocus();
	}
	
}

/**
 * Sent when default selection occurs in the control.
 * <p>
 * For example, on some platforms default selection occurs
 * in a List when the user double-clicks an item or types
 * return in a Text.
 * </p>
 *
 * @param e an event containing information about the default selection
 */
public void widgetDefaultSelected(SelectionEvent e)
{}
/**
 * Sent when selection occurs in the control.
 * <p>
 * For example, on some platforms selection occurs in
 * a List when the user selects an item or items.
 * </p>
 *
 * @param e an event containing information about the selection
 */
public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _browseLocation)
	  showResourceDialog();
	else if(e.widget == _browseMonitor)
	  showMonitorsDialog();
}

}
