/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ACPreferencePage.java,v 1.4 2009/05/27 20:59:29 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.CommonConstants;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ACPreferencePage extends PreferencePage
	implements IWorkbenchPreferencePage, ModifyListener, SelectionListener {
	
	private Text _localPort;
	private Button _firewallBtn;
	private Composite portComp;
	private Label firewallDesc;
	private Button randomPort; 
	private Button customPort;
    private Text portText;
    private Label acStatus;
    
	public Composite createControls(Composite parent)
	{
		GridLayout layout;
		GridData data;
		
		Composite content = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 10;
		content.setLayout(layout);
		content.setLayoutData(GridUtil.createFill()); 
		
		/* Agent Controller Status group */
		Group acStatusGroup = new Group(content, SWT.NULL);
		acStatusGroup.setText(ACPrefMessages._12);
		layout = new GridLayout();
		layout.numColumns = 1;
		acStatusGroup.setLayout(layout);
		acStatusGroup.setLayoutData(GridUtil.createHorizontalFill());
		
		acStatus = new Label(acStatusGroup, SWT.NULL);
		/*
		 * org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop.isIACRunning() checks for the 
		 * IAC Socket to be in use, this will check for both the IAC and AC 
		 */
		acStatus.setText(getIACStatus());
		
		/*
		 * Set the display to update the Agent Controller Status label.
		 */
		final Display controlDisplay = content.getDisplay(); 
		controlDisplay.timerExec(0, new Runnable(){
		
			public void run() {
				try {
					acStatus.setText(getIACStatus());
					controlDisplay.timerExec(5000, this);
				} catch (SWTException e) {
					// Bug 
					// The thread has been discarded, caused by the Preference page dialog being closed/disposed.
					// The error that the widget has been disposed can be ignored.
				}
			}
		});
						
		Group profilingInfo = new Group(content, SWT.NULL);
		profilingInfo.setText(ACPrefMessages._1);	
		layout = new GridLayout();
		layout.numColumns = 2;
		profilingInfo.setLayout(layout);
		profilingInfo.setLayoutData(GridUtil.createHorizontalFill());
		
		Label portdesc = new Label(profilingInfo, SWT.NULL);
		portdesc.setText(ACPrefMessages._2);
		_localPort = new Text(profilingInfo, SWT.BORDER);
		data = GridUtil.createHorizontalFill();
		_localPort.setLayoutData(data);
		_localPort.addModifyListener(this);
		
		Group portGrp = new Group(content, SWT.NULL);
		portGrp.setText(ACPrefMessages._11);	
		layout = new GridLayout();
		layout.numColumns = 1;
		portGrp.setLayout(layout);
		portGrp.setLayoutData(GridUtil.createHorizontalFill());
		
		_firewallBtn = new Button(portGrp, SWT.CHECK);
		_firewallBtn.setText(ACPrefMessages._6);
		_firewallBtn.addSelectionListener(this);
		
		portComp = new Composite(portGrp, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 5;
		portComp.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns=2;
		portComp.setLayout(layout);
				
		firewallDesc = new Label(portComp, SWT.NULL);
		firewallDesc.setText(ACPrefMessages._10);
		data =  new GridData();
		data.horizontalSpan=2;
		firewallDesc.setLayoutData(data);
		
		randomPort = new Button(portComp,SWT.RADIO);
		randomPort.setText(ACPrefMessages._7);
		data = new GridData();
		data.horizontalSpan=2;
		randomPort.setLayoutData(data);
		randomPort.addSelectionListener(this);
		
		customPort = new Button(portComp,SWT.RADIO);
		customPort.setText(ACPrefMessages._8);
		customPort.addSelectionListener(this);
		
		portText = new Text(portComp, SWT.BORDER);
		data = new GridData(SWT.FILL,SWT.DEFAULT,true,false);
		portText.setLayoutData(data);
		portText.addModifyListener(this);

		Label note = new Label(portComp, SWT.NULL);
		note.setText(ACPrefMessages._9);
		data =  new GridData();
		data.horizontalSpan=2;
		note.setLayoutData(data);
		
		initializeValues();
		
		Dialog.applyDialogFont( content );
		
		return content;  
	}
	
	private void enablePortComp(boolean enabled) {
		firewallDesc.setEnabled(enabled);
		randomPort.setEnabled(enabled);
		customPort.setEnabled(enabled);
		portText.setEnabled(customPort.getSelection());		
	}
	
	private void initializeValues()
	{
		IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
		setLocalHostPort(store.getString(CommonUIConstants.LOCALHOST_PORT));
		
		store = AdminPlugin.getDefault().getPreferenceStore();
		_firewallBtn.setSelection(store.getBoolean(CommonConstants.DATAPOOL_PORT_ENABLED));
		portText.setText(store.getString(CommonConstants.DATAPOOL_PORT_NUMBER));
		randomPort.setSelection(store.getBoolean(CommonConstants.DATAPOOL_PORT_RANDOM));
		customPort.setSelection(!store.getBoolean(CommonConstants.DATAPOOL_PORT_RANDOM));
		
		enablePortComp(_firewallBtn.getSelection());	
		
		valideInput();
	}


	public String getLocalPortNumber() {
		return _localPort.getText().trim();
	}
	
	public void setLocalHostPort(String portNum)
	{
		_localPort.setText(portNum);
	}
	
	public void modifyText(ModifyEvent e)
	{
		valideInput();
	}

	public void valideInput() {
		validateLocalPort();
		if (getErrorMessage()==null && _firewallBtn.getSelection() && customPort.getSelection()) {
			validateFirewallPort();
		}
	}
	
	public void validateLocalPort() {
		try
		{
			if (_localPort.getText().trim() == "")
			{
				setErrorMessage(ACPrefMessages._3);
				setValid(false);
				return;
			}
			
			int value = Integer.parseInt(_localPort.getText().trim());
			if (value<0)
			{
				setErrorMessage(ACPrefMessages._4);
				setValid(false);
				_localPort.setFocus();
				return;
			}
			setErrorMessage(null);
			setValid(true);
		}
		catch (NumberFormatException nfe)
		{
			if (this != null)
				setErrorMessage(ACPrefMessages._4);
				setValid(false);
//				_localPort.setFocus();
		}
	}
	
	public void validateFirewallPort() 
	{
		try
		{
			
			if (portText.getText().trim() == "")
			{
				if (!customPort.getSelection()) {
					setErrorMessage(null);
					setValid(true);
				}
				else {
					setErrorMessage(ACPrefMessages._5);
					setValid(false);
				}
				return;
			}
			
			int value = Integer.parseInt(portText.getText().trim());
			if (value<0)
			{
				setErrorMessage(ACPrefMessages._5);
				setValid(false);
				portText.setFocus();
				return;
			}
			setErrorMessage(null);
			setValid(true);
		}
		catch (NumberFormatException nfe)
		{
			if (this != null)
				setErrorMessage(ACPrefMessages._5);
				setValid(false);
//				portText.setFocus();
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
        // Do nothing
	}

	public Control createContents(Composite parent) {

		Composite comp = new Composite( parent, SWT.NONE );
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,CommonUITracePlugin.PLUGIN_ID+".fwps0000");
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 5;	
		layout.numColumns= 1;		
		comp.setLayout(layout);
		
		createControls(comp);

		Dialog.applyDialogFont( comp );
		
		return comp;
	}
	
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults()
	{
		IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore(); 
		setLocalHostPort(store.getDefaultString(CommonUIConstants.LOCALHOST_PORT));

		store = AdminPlugin.getDefault().getPreferenceStore();
		_firewallBtn.setSelection(store.getDefaultBoolean(CommonConstants.DATAPOOL_PORT_ENABLED));
		portText.setText(store.getDefaultString(CommonConstants.DATAPOOL_PORT_NUMBER));
		randomPort.setSelection(store.getDefaultBoolean(CommonConstants.DATAPOOL_PORT_RANDOM));
		customPort.setSelection(!store.getDefaultBoolean(CommonConstants.DATAPOOL_PORT_RANDOM));
		
		enablePortComp(_firewallBtn.getSelection());	
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
		valideInput();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		CommonUIPlugin.getDefault().savePluginPreferences();
		return true;
	}
	
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues()
	{		
		IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
		store.setValue(CommonUIConstants.LOCALHOST_PORT, this.getLocalPortNumber());	
		
		store = AdminPlugin.getDefault().getPreferenceStore();
		store.setValue(CommonConstants.DATAPOOL_PORT_ENABLED,_firewallBtn.getSelection());
		store.setValue(CommonConstants.DATAPOOL_PORT_NUMBER,portText.getText().trim());
		store.setValue(CommonConstants.DATAPOOL_PORT_RANDOM,randomPort.getSelection());
	}

	public void widgetDefaultSelected(SelectionEvent event) {}

	public void widgetSelected(SelectionEvent event) {
		if (event.widget==_firewallBtn) {
			enablePortComp(_firewallBtn.getSelection());
		}
		else if (event.widget==randomPort) {
			portText.setEnabled(!randomPort.getSelection());
		}
		else if (event.widget==customPort) {
			portText.setEnabled(customPort.getSelection());
		}
		
		valideInput();
	}
	
	/**
	 * Uses org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop.isIACRunning() which checks for the 
	 * IAC Socket to be in use, for both the IAC and AC. 
	 * @return The status wether the IAC is running or not.
	 */
	private String getIACStatus() {
		return AutoStartStop.isIACRunning() ? ACPrefMessages._13 : ACPrefMessages._14;
	}
	
}

