/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractChangeable.java,v 1.4 2008/01/24 02:29:57 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/**
 * Provides listener capabilities to subclasses. This is used by the Trace__UI
 * classes in order for the launch configuration tabs to be notified when the
 * UI has changed. Whenever any of the values change, <code>changed()</code>
 * should be called.
 */
public abstract class AbstractChangeable
{
	protected static final Event EVENT = new Event();
	protected final List _listeners = new ArrayList();

	/**
	 * Adds a <code>Listener</code> to be notified whenever this instance
	 * changes. A default <code>Event</code> is fired.
	 * 
	 * @param l The Listener to add.  
	 */
	public void addListener(Listener l)
	{
		synchronized(_listeners)
		{
			_listeners.add(l);
		}
	}

	/**
	 * Removes the given <code>Listener</code> from the list of <code>
	 * Listener</code>s to be notified when this instance changes.
	 *  
	 *	@param l The Listener to add.  
	 */
	public void removeListener(Listener l)
	{
		synchronized(_listeners)
		{
			_listeners.remove(l);
		}
	}
	
	/**
	 * Subclasses should call this whenever their values change, to signal
	 * any <code>Listener</code>s on this instance.
	 */
	protected void changed()
	{
		synchronized(_listeners)
		{
			Iterator i = _listeners.iterator();
			while (i.hasNext())
				((Listener)i.next()).handleEvent(EVENT);
		}
	}
}
