/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorDrillDownAdapter.java,v 1.2 2006/09/20 21:21:01 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.part.DrillDownAdapter;

/**
 * Implements a simple web style navigation metaphor for a <code>TreeViewer</code>.  
 * Home, back, and "drill into" functions are supported for the viewer,
 * <p>
 */
public class MonitorDrillDownAdapter extends DrillDownAdapter 
{
/**
 * Allocates a new DrillDownTreePart.
 *
 * @param tree the target tree for refocusing
 */
public MonitorDrillDownAdapter(TreeViewer tree)
{
	super(tree);
}
/**
 * Returns whether "go into" is possible for child tree.  This is only possible 
 * if the current selection in the client has one item and it has children.
 *
 * @return <code>true</code> if "go into" is possible; <code>false</code> otherwise
 */
public boolean canGoInto()
{
	try {
		return super.canGoInto();
	}
	catch(Exception exc)
	{
		return false;
	}
}
}
