/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorLabelProvider.java,v 1.3 2008/01/24 02:29:57 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class MonitorLabelProvider extends LabelProvider
{
  protected Image fMonitor = CommonUITraceImages.INSTANCE.getImage(CommonUITraceImages.IMG_UI_MONITOR);

/**
 * Returns the image to display for the passed resource element.
 * NOTE: The resource label provider caches its images, so don't
 * dispose them!
 */
public Image getImage(Object element)
{
	if (element instanceof IFile)
	{
	  return fMonitor;		
	}	
	else if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? null : adapter.getImageDescriptor(element).createImage();

	}
	else if(element instanceof TRCMonitor)
	  return fMonitor;

	return(null);
}
/* (non-Javadoc)
 * Method declared on ILabelProvider.
 */
public String getText(Object element)
{
	if (element instanceof IFile)
	{
		IFile file = (IFile)element;
		
		return file.getName().substring(0, file.getName().length()-file.getFileExtension().length()-1);
	}	
	else if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? "?" : adapter.getLabel(element);
	}
	else if(element instanceof TRCMonitor)
	  return ((TRCMonitor)element).getName();
	  
	return "";
}
}
