/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorSelectionDialog.java,v 1.3 2008/01/24 02:29:57 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

/**
 * Provides selection dialog for selecting monitors
 */
public class MonitorSelectionDialog extends SelectionDialog
						implements ISelectionValidator
								   , Listener
{

  public static final int MONITOR       = 1;
  public static final int FOLDER         = 2;
  public static final int ALL            = MONITOR;
  
  // the widget group;
  protected MonitorSelectionGroup group;

  // the validation message
  protected Label statusMessage;

  /**
   * Creates a resource container selection dialog rooted at the given resource.
   * All selections are considered valid. Equivalent to
   * <code>new ContainerSelectionDialog(initialRoot,allowNewContainerName,message,null)</code>.
   *
   * @param parentShell the parent shell
   * @param initialRoot the root resource to populate the resource viewer
   *  with
   * @param allowNewContainerName <code>true</code> to enable the user to type in
   *  a new container name, and <code>false</code> to restrict the user to just
   *  selecting from existing ones
   * @param message the message to be displayed at the top of this dialog, or
   *    <code>null</code> to display a default message
   */
  public MonitorSelectionDialog(Shell parentShell, String message) {
	this(parentShell, message, SWT.NONE, ALL);
  }      
  public MonitorSelectionDialog(Shell parentShell, String message, int style, int type) {
	super(parentShell);
	setTitle(CommonUITraceMessages.MON_SELTT);
	if (message != null)
		setMessage(message);
	else
		setMessage(CommonUITraceMessages.MON_SELT);		

  }                  
protected Control createButtonBar(Composite parent)
{
	Control result = super.createButtonBar(parent);

	statusMessage.setForeground(statusMessage.getDisplay().getSystemColor(SWT.COLOR_RED));	
	statusMessage.setText(CommonUITraceMessages.MON_SELT);	
	getOkButton().setEnabled(false);	
	return result;
}
  /* (non-Javadoc)
   * Method declared on Dialog.
   */
  protected Control createDialogArea(Composite parent) {
	// create composite 
	Composite dialogArea = (Composite)super.createDialogArea(parent);
	// container selection group
	group = new MonitorSelectionGroup(dialogArea, this, true);
	    
	statusMessage = new Label(parent, SWT.NONE);
	statusMessage.setLayoutData(new GridData(GridData.FILL_BOTH));
	
	return dialogArea;
}
	public void handleEvent (Event event) {
		if (statusMessage != null) {
			String errorMsg = isValid(group.getContainerFullPath());
			if (errorMsg == null || errorMsg.equals("")) {
				statusMessage.setText("");
				getOkButton().setEnabled(true);
			} else {
				statusMessage.setForeground(statusMessage.getDisplay().getSystemColor(SWT.COLOR_RED));
				statusMessage.setText(errorMsg);
				getOkButton().setEnabled(false);
			}
		}
	}
public String isValid(Object selection)
{
	IPath path = (IPath)selection;

	if(path == null)
	  return null;

	IWorkspaceRoot root = CommonPlugin.getRoot();
	
	IResource res = root.findMember(path);
	if(res != null && res instanceof IContainer)
	{
		return CommonUITraceMessages.MON_SELT;
	}
	else if(path.segmentCount() == 1)
	{
		return CommonUITraceMessages.INVMON;
	}
	 
	return null;
}
/**
 * The <code>ContainerSelectionDialog</code> implementation of this 
 * <code>Dialog</code> method builds a list of the selected resource containers
 * for later retrieval by the client and closes this dialog.
 */
protected void okPressed() {

	ArrayList chosenContainerPathList = new ArrayList();
		chosenContainerPathList.add(group.getContainerFullPath());
	setResult(chosenContainerPathList);
	
	super.okPressed();
}
}
