/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.ui.extension.IAssociationConstants;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.IPropertyListener;

/**
 * Contains utility methods to work with the Trace Association extensions.
 */

public class TraceAssociationMapping implements IPropertyListener{

	protected Map typeClassMap;
	protected static TraceAssociationMapping inst;
		
	protected TraceAssociationMapping() {
		super();

		if (typeClassMap==null) 
			typeClassMap = new HashMap();

		TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener(this);
		
	}
	
	public static TraceAssociationMapping getDefault() {
		if (inst==null)
			inst = new TraceAssociationMapping();
		return inst;
	}
	

	public Object[] getClassForTypeUnsorted(String type) {
		
		
		Object mapp = typeClassMap.get(type);
    	
		if(mapp != null)
			return (Object[])mapp;
    	    
		IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
		IAssociationMapping mapping = registry.getAssociationMapping(IAssociationConstants.EP_ANALYZER_EXTENSIONS);
		
		if(mapping == null)
		{
			Object[] viewIDs = new Object[0];
			typeClassMap.put(type, viewIDs);
			
			return viewIDs;
		}
    		    		  
		IAssociationDescriptor[] array = mapping.getAssociationDescriptors(type);
		Object[] viewIDs = new Object[array.length];
		
		for(int idx=0; idx<array.length; idx++)
		{
			IAssociationDescriptor desc = array[idx];
				
			try {
					
				Object implClass = desc.createImplementationClassInstance();
				
				if(implClass != null)
				{
					viewIDs[idx] = implClass;
					
					if (!(implClass instanceof OpenAssociatedTraceViewAction)) {
					{
						IStatus status = new Status(IStatus.INFO, CommonUITracePlugin.PLUGIN_ID,0,implClass.getClass().getName() + " should extend OpenAssociatedTraceViewAction", null); //$NON-NLS-1$
			            CommonPlugin.logError(status);	
			            System.out.println(implClass.getClass().getName() + " should extend OpenAssociatedTraceViewAction");					}
					}
					
				}								
			} catch (Exception exc) {
				exc.printStackTrace();
			}
								
		}
		
		typeClassMap.put(type, viewIDs);
		return viewIDs;	        	  
	}
	
	public boolean isViewForType(String viewID, String type) {
		Object[] viewIDs = getClassForTypeUnsorted(type);
		for (int i=0;i<viewIDs.length;i++)
		{
			Object implClass = (Object)viewIDs[i];
			if (implClass instanceof OpenAssociatedTraceViewAction) {
				if (((OpenAssociatedTraceViewAction)implClass).getViewID().equals(viewID))
					return true;
			}
		}
		return false;
	}
	
	public void clear()
	{
		if(typeClassMap != null)
			typeClassMap.clear();
	}
	
	public void dispose()
	{
		clear();
		typeClassMap=null;
	}

	public void propertyChanged(Object source, int propId) {
		//reset trace view actions
		if(source instanceof IAssociationMappingRegistry)
			clear();
	}
	
}
