/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewNodeWizard.java,v 1.2 2007/03/20 13:45:35 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;

import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.IWorkbench;

public class NewNodeWizard extends NavigatorWizard /* Ali M.: Extended Navigator wizard */
{
	protected NewNodeWizardPage fPage;
	protected TRCMonitor fMonitor;

	public NewNodeWizard()
	{
		setNeedsProgressMonitor(true);
	}

	public void addPages()
	{
		setWindowTitle(CommonUITraceMessages.NEWN_T);
		fPage = new NewNodeWizardPage("NewNodePage", fMonitor, getViewer());
		addPage(fPage);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		if (selection instanceof IStructuredSelection)
		{
			Iterator enum1 = ((IStructuredSelection) selection).iterator();
			if (enum1.hasNext())
			{
				Object obj = enum1.next();
				if (obj instanceof TRCMonitor)
					fMonitor = (TRCMonitor) obj;
			}
		}

		setDefaultPageImageDescriptor(CommonUITraceImages.INSTANCE.getImageDescriptor(CommonUITraceImages.IMG_UI_WZ_NEWNODE));
	}

	public boolean performFinish()
	{
		if (fPage.finish())
		{
			getViewer().getViewer().refresh(fMonitor);
			getViewer().getViewer().setSelection(new StructuredSelection(fPage.getNode()));

			return true;

		}

		return false;
	}
}
