/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewNodeWizardPage.java,v 1.3 2008/01/24 02:29:59 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.util.PDCoreUtil;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID nhwp0000 for in new host wizard page
*/

public class NewNodeWizardPage  extends WizardPage 
			   implements ModifyListener
 
{
	protected TRCMonitor fMonitor;
	protected Object    fNodeFile;
	protected TRCNode    fNode;

	protected TraceLocationUI _locationUI;
	protected TraceNodeUI _nodeUI;	

  public NewNodeWizardPage(String name)
  {
	super(name);
  }  
  public NewNodeWizardPage(String name, TRCMonitor monitor
						   , INavigator viewer)
  {
	super(name);
	
	setTitle(CommonUITraceMessages.C_NNODE);
	setDescription(CommonUITraceMessages.C_NNODED);
	
	fMonitor = monitor;
  }    
  public void createControl(Composite parent)
  {
	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = new GridData();
	gd.verticalAlignment   = GridData.FILL;
	gd.horizontalAlignment = GridData.FILL;
	gd.grabExcessHorizontalSpace = true;
	gd.widthHint = 500; 
	content.setLayoutData(gd);

	_locationUI = new TraceLocationUI();
	_locationUI.createControl(content);
	_locationUI.setEnabled(false);	
		
	_nodeUI = new TraceNodeUI();
	_nodeUI.createControl(content);
				
	//add listeners
	_nodeUI.getNodeNameUI().addModifyListener(this);
	_nodeUI.getAddressUI().addModifyListener(this);
	_nodeUI.getPortNumberUI().addModifyListener(this); 
	
	_nodeUI.getHourUI().addModifyListener(this);
	_nodeUI.getMinUI().addModifyListener(this);
	_nodeUI.getSecUI().addModifyListener(this);  
	_nodeUI.getMicSecUI().addModifyListener(this);  
		
	setPageComplete(false);
	
	setControl(content);
	
	IResource selection = HyadesUtil.getSelectionFolder(((NewNodeWizard)getWizard()).getViewer());

	if(selection != null)
	   _locationUI.setLocation(selection.getFullPath().toOSString());  

	 if(fMonitor != null)
		_locationUI.setMonitor(fMonitor.getName());    
		
	 PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CommonUITraceConstants.TRACE_UI_PLUGIN_ID+".nhwp0000");	
  }          
  public boolean finish()
  {
	  String name = _nodeUI.getNodeNameUI().getText().trim();
	  String address = _nodeUI.getAddressUI().getText().trim();
	  String portNumber = _nodeUI.getPortNumberUI().getText().trim();
	  
	  TRCNode node = null;
	  if(!name.equals(""))
		  node = PDCoreUtil.createNode(fMonitor, name, portNumber);
	  else
		  node = PDCoreUtil.createNode(fMonitor, address, portNumber);
		   
	  if(node != null)
	    node.setDeltaTime(_nodeUI.getDeltaTime());
	      
	  return(true);
  }  
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 2:07:27 PM)
 * @return java.lang.Object
 */
public Object getNode() {
	return fNode;
}

protected boolean pageComplete()
{
		String name = _nodeUI.getNodeNameUI().getText().trim();
		String address = _nodeUI.getAddressUI().getText().trim();
		String port = _nodeUI.getPortNumberUI().getText().trim();	
		String hour = _nodeUI.getHourUI().getText().trim();
		String min = _nodeUI.getMinUI().getText().trim();
		String sec = _nodeUI.getSecUI().getText().trim();
		String micsec = _nodeUI.getMicSecUI().getText().trim();
	
		if (!(name.equals("") && address.equals(""))
			&&  (Integer.parseInt(port)>=0)
			&&  (hour.equals("") || Integer.parseInt(hour)>=0)
			&&  (min.equals("") || (Integer.parseInt(min)>=0 && Integer.parseInt(min)<60))
			&&  (sec.equals("") || (Integer.parseInt(sec)>=0 && Integer.parseInt(sec)<60))
			&&  (micsec.equals("") || (Integer.parseInt(micsec)>=0 && Integer.parseInt(micsec)<1000000))
			)
			return true;
		else
			return false;
}

/**
 * Insert the method's description here.
 * Creation date: (08/21/2000 7:51:52 PM)
 * @param event org.eclipse.swt.events.ModifyEvent
 */
public void modifyText(ModifyEvent event)
{
	String fileName = null;
	
	setPageComplete(true);

	String name = _nodeUI.getNodeNameUI().getText().trim();
	String address = _nodeUI.getAddressUI().getText().trim();
	String port = _nodeUI.getPortNumberUI().getText().trim();
	
	if (event.widget == _nodeUI.getNodeNameUI())
	{
		fileName = name;
		setPageComplete(pageComplete());
	}
	else if (event.widget == _nodeUI.getAddressUI())
	{
		fileName = address;
		setPageComplete(pageComplete());
		fileName = "["+fileName+"]";
	}
	else if (event.widget == _nodeUI.getPortNumberUI())
	{
		try {
			int value = Integer.parseInt(port);
			if (value<0)
			{
				setErrorMessage(CommonUITraceMessages.RAC_INV_PRT);
				setPageComplete(pageComplete());
				return;
			}
			setErrorMessage(null);  
			setPageComplete(pageComplete());
		} catch (NumberFormatException nfe) {
			setErrorMessage(CommonUITraceMessages.RAC_INV_PRT);  
			setPageComplete(false);
		}
	}
	else if (event.widget == _nodeUI.getHourUI())
	{
		try {
			int minValue = Integer.parseInt(_nodeUI.getHourUI().getText().trim());
			
			if (minValue<0)
			{
				setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(pageComplete());
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getHourUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}		
				setErrorMessage(CommonUITraceMessages.INVDELT_FMT);

				setPageComplete(false);			
		}
	}
	else if (event.widget == _nodeUI.getMinUI())
	{
		try {
			int minValue = Integer.parseInt(_nodeUI.getMinUI().getText().trim());
			
			if (minValue<0 || minValue >59)
			{
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(pageComplete());
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getMinUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}			
				setPageComplete(false);			
		}
	}
	else if (event.widget == _nodeUI.getSecUI())
	{
		try {
			int minValue = Integer.parseInt(_nodeUI.getSecUI().getText().trim());
			
			if (minValue<0 || minValue >59)
			{
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(pageComplete());
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getSecUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}
				setPageComplete(false);			
		}
	}
	else if (event.widget == _nodeUI.getMicSecUI())
	{
		try {
			int micsecValue = Integer.parseInt(_nodeUI.getMicSecUI().getText().trim());
			
			if (micsecValue<0 || micsecValue >1000000)
			{
				setPageComplete(false);
				return;
			}
			setErrorMessage(null);
			setPageComplete(pageComplete());
		}
		catch (NumberFormatException e)
		{
				if (_nodeUI.getMicSecUI().getText().trim().equals(""))
				{
					setErrorMessage(null);
					setPageComplete(true);
					return;
				}
				setPageComplete(false);			
		}
	}

	if (isPageComplete()) 
	{           
		setErrorMessage(null);          

		EList nodes = fMonitor.getNodes();
		Iterator i = nodes.iterator();
		while (i.hasNext())
		{
			TRCNode node = (TRCNode)i.next();
			if(node.eIsProxy())
				continue;
		
			if(node.getName().equals(fileName))
			{
				setErrorMessage(NLS.bind(CommonUITraceMessages.NODE_ALD_EX, new Object[] {fileName, fMonitor.getName()}));                                   
				setPageComplete(false);
				return;                 
			}
		}
			
	}
}
}
