/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenNodeWizard.java,v 1.2 2007/03/20 13:47:05 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.IWorkbench;

public class OpenNodeWizard extends NewNodeWizard {
	protected TRCNode fNode;

	public OpenNodeWizard() 
	{
		super();
	}

	public void addPages() {
		setWindowTitle(CommonUITraceMessages.PROP);
		fPage = new OpenNodeWizardPage("OpenNodePage");
		addPage(fPage);
	}

	public TRCNode getNode() {
		return fNode;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) 
	{
		if (selection instanceof IStructuredSelection) 
		{
			Iterator enum1 = ((IStructuredSelection) selection).iterator();
			if (enum1.hasNext()) 
			{
				Object obj = enum1.next();
				if (obj instanceof TRCNode)
					fNode = (TRCNode) obj;
			}
		}

		setDefaultPageImageDescriptor(CommonUITraceImages.INSTANCE.getImageDescriptor(CommonUITraceImages.IMG_UI_WZ_NODE_PROP));	
	}

	public boolean performFinish() 
	{
		if (fPage.finish()) 
		{
			fNode.setPort(Integer.parseInt(fPage._nodeUI.getPortNumberUI().getText().trim()));
			getViewer().getViewer().refresh(fNode.getMonitor());
			return true;
		}

		return false;
	}
}
