/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenNodeWizardPage.java,v 1.4 2007/11/27 04:47:11 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID onwp0000 for open node wizard page
 */

public class OpenNodeWizardPage extends NewNodeWizardPage implements
		ModifyListener {
	protected int hourValue = 0;

	protected int minValue = 0;

	protected int secValue = 0;

	protected int micsecValue = 0;

	public OpenNodeWizardPage(String name) {
		super(name);
		setTitle(CommonUITraceMessages.NODP_T);
		setDescription(CommonUITraceMessages.NODP_TD);
	}

	public void createControl(Composite parent) {
		super.createControl(parent);

		_nodeUI.setEnabled(false);

		populateData();
		setPageComplete(true);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CommonUITraceConstants.TRACE_UI_PLUGIN_ID + ".onwp0000");
	}

	public boolean finish() {
		TRCNode node = ((OpenNodeWizard) getWizard()).getNode();

		if (node == null)
			return true;

		if (node.getDeltaTime() != _nodeUI.getDeltaTime()) {
			node.setDeltaTime(_nodeUI.getDeltaTime());

			ProfileEvent event = TraceUIManager.getTraceUIManager().getProfileEvent();
			event.setSource(node);
			event.setType(ProfileEvent.UPDATE_DELTA_TIME);
			TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
		}

		return (true);
	}

	public void modifyText(ModifyEvent event) {
		setPageComplete(true);

		String port = _nodeUI.getPortNumberUI().getText().trim();

		if (event.widget == _nodeUI.getPortNumberUI()) {
			try {
				int value = Integer.parseInt(port);
				//port filed is disable if por=-1 ie local direct connection
				if (value < 0 && _nodeUI.getPortNumberUI().getEnabled()==true) {
					setErrorMessage(CommonUITraceMessages.RAC_INV_PRT);
					setPageComplete(false);
					return;
				}
				setErrorMessage(null);
				setPageComplete(true);
			} catch (NumberFormatException nfe) {
				setErrorMessage(CommonUITraceMessages.RAC_INV_PRT);
				setPageComplete(false);			
			}
		} else if (event.widget == _nodeUI.getHourUI()) {
			try {
				hourValue = Integer.parseInt(_nodeUI.getHourUI().getText()
						.trim());
				setErrorMessage(null);
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_nodeUI.getHourUI().getText().trim().equals("")) {
					hourValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = CommonUITraceMessages.INVDELT_FMT;
				setErrorMessage(message);
				setPageComplete(false);
			}
		} else if (event.widget == _nodeUI.getMinUI()) {
			try {
				minValue = Integer
						.parseInt(_nodeUI.getMinUI().getText().trim());
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_nodeUI.getMinUI().getText().trim().equals("")) {
					minValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = CommonUITraceMessages.INVDELT_FMT;
				setErrorMessage(message);

				setPageComplete(false);
			}
		} else if (event.widget == _nodeUI.getSecUI()) {
			try {
				secValue = Integer
						.parseInt(_nodeUI.getSecUI().getText().trim());
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_nodeUI.getSecUI().getText().trim().equals("")) {
					secValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = CommonUITraceMessages.INVDELT_FMT;
				setErrorMessage(message);

				setPageComplete(false);
			}
		} else if (event.widget == _nodeUI.getMicSecUI()) {
			try {
				micsecValue = Integer.parseInt(_nodeUI.getMicSecUI().getText()
						.trim());
				setPageComplete(canCompletePage());
			} catch (NumberFormatException e) {
				if (_nodeUI.getMicSecUI().getText().trim().equals("")) {
					micsecValue = 0;
					setPageComplete(canCompletePage());
					return;
				}
				String message = CommonUITraceMessages.INVDELT_FMT;
				setErrorMessage(message);

				setPageComplete(false);
			}
		}

	}

	/**
	 * Insert the method's description here. Creation date: (10/05/2000 3:17:53
	 * PM)
	 */
	protected void populateData() {
		TRCNode node = ((OpenNodeWizard) getWizard()).getNode();

		if (node == null)
			return;

		_nodeUI.getNodeNameUI().setText(node.getName());
		_nodeUI.getPortNumberUI().setText(String.valueOf(node.getPort()));
		_nodeUI.getPortNumberUI().setEnabled(true);
	
		if (node.getIpAddress() != null)
			_nodeUI.getAddressUI().setText(node.getIpAddress());

		_locationUI.setMonitor(node.getMonitor().getName());

		double delta = node.getDeltaTime();
		if (delta != 0)
			_nodeUI.setDeltaTime(delta);
	}

	protected boolean canCompletePage() {

		return isHourValid() && isMinValid() && isSecValid() && isMicsecValid();

	}

	protected boolean isHourValid() {
		String hour = _nodeUI.getHourUI().getText().trim();
		try {
			hourValue = Integer.parseInt(hour);
		} catch (Exception e) {
			if (!hour.equals("")) {
				setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
				return false;
			}
		}
		setErrorMessage(null);
		return true;
	}

	protected boolean isMinValid() {
		int minValue = 0;
		String hour = _nodeUI.getHourUI().getText().trim();
		String min = _nodeUI.getMinUI().getText().trim();
		try {
			minValue = Integer.parseInt(min);
		} catch (Exception e) {
			if (!_nodeUI.getMinUI().getText().trim().equals("")) {
				setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
				return false;
			}

		}
		if (!hour.equals("") && hourValue != 0
				&& !(minValue >= 0 && minValue < 60)) {
			setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
			return false;
		}
		setErrorMessage(null);
		return true;

	}

	protected boolean isSecValid() {
		int secValue = 0;
		String hour = _nodeUI.getHourUI().getText().trim();
		String min = _nodeUI.getMinUI().getText().trim();
		String sec = _nodeUI.getSecUI().getText().trim();
		try {
			secValue = Integer.parseInt(sec);
		} catch (Exception e) {
			if (!_nodeUI.getSecUI().getText().trim().equals("")) {
				setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
				return false;
			}

		}
		if (((!hour.equals("") && hourValue != 0) || (!min.equals("") && minValue != 0))
				&& !(secValue >= 0 && secValue < 60)) {
			setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
			return false;
		}
		setErrorMessage(null);
		return true;
	}

	protected boolean isMicsecValid() {
		String hour = _nodeUI.getHourUI().getText().trim();
		String min = _nodeUI.getMinUI().getText().trim();
		String sec = _nodeUI.getSecUI().getText().trim();
		String micsec = _nodeUI.getMicSecUI().getText().trim();
		try {
			micsecValue = Integer.parseInt(micsec);
		} catch (Exception e) {
			if (!_nodeUI.getMicSecUI().getText().trim().equals("")) {
				setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
				return false;
			}

		}
		if ((((!hour.equals("") && hourValue != 0) || (!min.equals("") && minValue != 0)) || (!sec
				.equals("") && secValue != 0))
				&& !(micsecValue >= 0 && micsecValue < 1000000)) {
			setErrorMessage(CommonUITraceMessages.INVDELT_FMT);
			return false;
		}
		setErrorMessage(null);
		return true;
	}

}
