/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonUITraceImages.java,v 1.4 2007/03/15 22:24:06 amehregani Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.common.ui.trace.internal;

import org.eclipse.hyades.ui.internal.util.ImageManager;


/**
 * @author Ali Mehregani
 * @since 4.3
 */
public class CommonUITraceImages extends ImageManager
{
	public static final CommonUITraceImages INSTANCE = new CommonUITraceImages();
	
	/* obj 16 */
	public static final String IMG_UI_MONITOR  				= "monitor_obj.gif"; 		//$NON-NLS-1$	
	public static final String IMG_UI_NODE       			= "node_obj.gif"; 			//$NON-NLS-1$
	public static final String IMG_UNCHECKED 				= "blank_obj.gif";			//$NON-NLS-1$
	public static final String IMG_UI_PROCESS    			= "process_obj.gif";		//$NON-NLS-1$
	public static final String IMG_UI_AGENT  				= "agent_obj.gif"; 			//$NON-NLS-1$
	public static final String IMG_UI_RUN_AGENT  			= "agent_run_obj.gif";		//$NON-NLS-1$
	public static final String IMG_UI_DETACHED_AGENT		= "agent_detach_obj.gif";	//$NON-NLS-1$
	public static final String IMG_UI_MON_AGENT  			= "agent_mon_obj.gif"; 		//$NON-NLS-1$
	public static final String IMG_UI_STOP_AGENT 			= "agent_stop_obj.gif";		//$NON-NLS-1$
	public static final String IMG_UI_LAYOUT_FLAT 			= "flat_layout.gif";		 //$NON-NLS-1$
	public static final String IMG_UI_LAYOUT_HIERARCHICAL 	= "hierarchical_layout.gif"; //$NON-NLS-1$	
	
	/* lcl16 */
	public static final String IMG_SAVE		 			= "save.gif";				//$NON-NLS-1$
	public static final String IMG_REFRESH		 		= "refresh.gif";			//$NON-NLS-1$
	public static final String IMG_HIDE_LOG_TYPE        = "hidetype.gif";			//$NON-NLS-1$
	
	/* wizbanh */
	public static final String IMG_UI_WZ_AGENT_PROP 	= "agent_prop_wiz.gif";		//$NON-NLS-1$
	public static final String IMG_UI_WZ_NODE_PROP 		= "node_prop__wiz.gif";		//$NON-NLS-1$
	public static final String IMG_UI_WZ_NEWNODE 		= "newnode_wiz.gif";		//$NON-NLS-1$
	
	protected void addImages() 
	{
		/* obj 16 */
		add(T_OBJ, IMG_UI_MONITOR);
		add(T_OBJ, IMG_UI_NODE);
		add(T_OBJ, IMG_UNCHECKED);
		add(T_OBJ, IMG_UI_PROCESS);
		add(T_OBJ, IMG_UI_AGENT);
		add(T_OBJ, IMG_UI_RUN_AGENT);
		add(T_OBJ, IMG_UI_DETACHED_AGENT);
		add(T_OBJ, IMG_UI_MON_AGENT);
		add(T_OBJ, IMG_UI_STOP_AGENT);
		add(T_OBJ, IMG_UI_LAYOUT_FLAT);
		add(T_OBJ, IMG_UI_LAYOUT_HIERARCHICAL);
		
		/* lcl16 */		
		add("c", T_LCL, IMG_SAVE);
		add("d", T_LCL, IMG_SAVE);
		add("e", T_LCL, IMG_SAVE);
			
		add("c", T_LCL, IMG_REFRESH);
		add("d", T_LCL, IMG_REFRESH);
		add("e", T_LCL, IMG_REFRESH);
				
		add("c", T_LCL, IMG_HIDE_LOG_TYPE);
		add("d", T_LCL, IMG_HIDE_LOG_TYPE);
		add("e", T_LCL, IMG_HIDE_LOG_TYPE);
		
		/* wizban */
		add(T_WIZBAN, IMG_UI_WZ_AGENT_PROP);
		add(T_WIZBAN, IMG_UI_WZ_NODE_PROP);
		add(T_WIZBAN, IMG_UI_WZ_NEWNODE);		
	}
	
	protected ImageManager getInstance()
	{
		return INSTANCE;
	}
}
