/********************************************************************** 
 * Copyright (c) 2006, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: CommonUITracePlugin.java,v 1.11 2008/04/30 12:42:14 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.common.ui.trace.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.ibm.icu.util.StringTokenizer;

/**
 * The activator class controls the plug-in life cycle
 */
public class CommonUITracePlugin extends AbstractUIPlugin implements Application	
{

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.tptp.platform.common.ui.trace";

	// The shared instance
	protected static CommonUITracePlugin plugin;

	/**
	 * The constructor
	 */
	public CommonUITracePlugin()
	{
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception
	{
		super.start(context);
		ImageManager.initializeImages(CommonUITraceImages.INSTANCE, this);
		updateHostPreference();
	}

	/**
	/** Update the host preference value to the new format in order
	/** to support the IPv6 format.
	/** @Since TPTP 4.5
	**/
	protected void updateHostPreference() {
		
		IPreferenceStore store = getPreferenceStore();
		String hostList = store.getString(CommonUIConstants.HOST_KEY);

		if (hostList.equals("localhost[10002]")
				|| store.getBoolean("HOSTPREF_UPDATED")) {
			store.setValue("HOSTPREF_UPDATED", true);
			return;
		}
		
		StringBuffer buff = new StringBuffer();
		
		StringTokenizer tokens = new StringTokenizer(hostList,",");
		while (tokens.hasMoreElements()) {
			String hostPort = (String) tokens.nextElement();
			int idx = hostPort.lastIndexOf(":");
			if (idx>0) {
				buff.append(hostPort.substring(0, idx)).append("[")
				.append(hostPort.subSequence(idx+1, hostPort.length())).append("]");
			}
			else {
				buff.append(hostPort);
			}
			buff.append(",");
		}
		
		String newPrefValue = buff.toString();
		
		
		store.setValue(CommonUIConstants.HOST_KEY, newPrefValue.substring(0, newPrefValue.length()-1));
		store.setValue("HOSTPREF_UPDATED", true);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception
	{
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static CommonUITracePlugin getDefault()
	{
		return plugin;
	}

	public String getName()
	{
		return PLUGIN_ID;
	}
	
	
	/**
	 * Sets default preference values. These values will be used
	 * until some preferences are actually set using Preference dialog.
	 * @param store IPreferenceStore, the preference store where the default values are stored.
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) 
	{		
		/* Default hosts */
		store.setDefault(CommonUIConstants.HOST_KEY,"localhost[10002]");
		
		/* Trace options */
		store.setDefault(CommonUITraceConstants.TRACE_PROJECT_NAME, CommonUITraceMessages.TRC_LOCD);
		store.setDefault(CommonUITraceConstants.TRACE_MONITOR_NAME, CommonUITraceMessages.TRC_MONT);
		store.setDefault(CommonUITraceConstants.LOG_PROJECT_NAME, "LogAnalyzerProject");
		store.setDefault(CommonUITraceConstants.LOG_MONITOR_NAME, "DefaultMonitor");
		store.setDefault(CommonUITraceConstants.SAVE_ON_EXIT_KEY, MessageDialogWithToggle.PROMPT);
	}
	
	
	public void log(Throwable e) 
	{
		getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage(), e));
	}

}
