/********************************************************************** 
 * Copyright (c) 2007, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: TraceUIHelper.java,v 1.3 2008/02/28 03:12:00 jkubasta Exp $ 
 *
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.common.ui.trace.internal;

import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.TraceAssociationMapping;
import org.eclipse.hyades.trace.ui.provisional.ITraceUIHelper;
import org.eclipse.jface.preference.IPreferenceStore;

public class TraceUIHelper implements ITraceUIHelper {

	public TraceUIHelper() {
		// TODO Auto-generated constructor stub
	}

	public void disposeTraceUIManager() {
		TraceUIManager.getTraceUIManager().dispose();
		
	}

	public Application getTraceUIApplication() {
		return CommonUITracePlugin.getDefault();
	}

	public IPreferenceStore getTraceUIPreferenceStore() {
		return CommonUITracePlugin.getDefault().getPreferenceStore();
	}

	public boolean isViewForType(String viewID, String type) {
		return TraceAssociationMapping.getDefault().isViewForType(viewID, type);
	}

	public void resetMonitors() {
		PDContentProvider.resetMonitors();
	}

}
