/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RefreshFromLocalAction.java,v 1.6 2009/08/05 21:55:32 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.common.ui.trace.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;

/*
 * CONTEXT_ID refl0000 for refresh from local action
 */

public class RefreshFromLocalAction extends SelectionProviderAction implements
		ISelectionChangedListener
{
	protected INavigator fViewer;

	public RefreshFromLocalAction(INavigator viewer)
	{
		super(viewer.getViewer(), CommonUITraceMessages.U_MEM);
		setDescription(Action.removeMnemonics(CommonUITraceMessages.U_MEM));
		fViewer = viewer;

		PlatformUI.getWorkbench().getHelpSystem().setHelp(this,
				CommonUITracePlugin.PLUGIN_ID + ".refl0000");

		setToolTipText(Action.removeMnemonics(CommonUITraceMessages.U_MEM));
	}

	public void run()
	{
		String preferenceKey = CommonUITracePlugin.getDefault().getPreferenceStore()
				.getString(CommonUITraceConstants.RELOAD_INFO);
		IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		Shell shell = window.getShell();
		boolean saveAndChange = false;

		if (CommonUITracePlugin.getDefault().getPreferenceStore().getBoolean(
				CommonUITraceConstants.RELOAD_INFO))
		{
			MessageDialogWithToggle dialog = MessageDialogWithToggle
					.openOkCancelConfirm(shell, 
							CommonUITraceMessages.TRC_MSGT,
							CommonUITraceMessages.REL_INF,
							CommonUITraceMessages.AT_MSGCB,
							false, CommonUITracePlugin.getDefault().getPreferenceStore(),
							preferenceKey);

			saveAndChange = (dialog.getReturnCode() == IDialogConstants.OK_ID);

			if (dialog.getToggleState())
			{
				CommonUITracePlugin.getDefault().getPreferenceStore().setValue(
						CommonUITraceConstants.RELOAD_INFO,
						Boolean.toString(!saveAndChange));
			}
			// Activate the shell if necessary so the prompt is visible
			if (shell.getMinimized())
			{
				shell.setMinimized(false);
			}
			if (!saveAndChange)
				return;
		}

		List list = getModifiedProcesses();
		if (!list.isEmpty())
		{
			final Object[] listArray = list.toArray();
			IStructuredContentProvider contentProvider = new IStructuredContentProvider()
			{

				public void dispose()
				{
				}

				public void inputChanged(Viewer viewer, Object oldInput,
						Object newInput)
				{
				}

				public Object[] getElements(Object inputElement)
				{
					return listArray;
				}
			};

			ListSelectionDialog dlg = new ListSelectionDialog(Display
					.getCurrent().getActiveShell(), listArray, contentProvider,
					new SimpleLayout(null).getLabelProvider(), CommonUITraceMessages.FREE_MEM);
			dlg.setInitialSelections(listArray);
			dlg.setTitle(CommonUITraceMessages.TRC_MSGT);

			int result = dlg.open();
			if (result == ListSelectionDialog.CANCEL)
				return;

			Object[] selections = dlg.getResult();
			if (listArray.length != selections.length)
			{
				if (!MessageDialog.openQuestion(Display.getCurrent().getActiveShell(), CommonUITraceMessages.TRC_MSGT, CommonUITraceMessages.FREE_MEM1))
					return;
			}

			try
			{
				SaveAction saveAction = new SaveAction(fViewer);
				saveAction.finishSaving(selections);
			} catch (Exception e)
			{
				CommonPlugin.logError(e);
			}
		}

		handleResources();

		fViewer.getViewer().refresh();
	}

	/**
	 * 
	 * @return true if there are any loaded agents
	 */
	public boolean areLoadedResources()
	{
		for (Iterator iter = HierarchyResourceSetImpl.getInstance()
				.getResources().iterator(); iter.hasNext();)
		{
			Resource element = (Resource) iter.next();
			if (element.isLoaded())
			{
				if (element.getContents().size() > 0
						&& element.getContents().get(0) instanceof TRCAgent)
					return true;
			}
		}
		return false;
	}

	/**
	 * 
	 * @return List - the list of modified processes; those are by definition
	 *         loaded into memory and need to be saved
	 */
	protected List getModifiedProcesses()
	{
		List list = new ArrayList();
		for (Iterator iter = HierarchyResourceSetImpl.getInstance()
				.getResources().iterator(); iter.hasNext();)
		{
			Resource element = (Resource) iter.next();
			if (element.isLoaded())
			{
				if (element.getContents().size() > 0
						&& element.getContents().get(0) instanceof TRCAgent)
				{
					if (element.isModified())
					{
						TRCAgent agent = (TRCAgent) element.getContents()
								.get(0);
						try
						{
							if (!list.contains(agent.getAgentProxy()
									.getProcessProxy()))
								list.add(agent.getAgentProxy()
										.getProcessProxy());
						} catch (Exception e)
						{
						}
					}
				}
			}
		}
		return list;
	}

	/**
	 * 
	 */
	public void selectionChanged(IStructuredSelection selection)
	{
		setEnabled(isEnabled());
	}

	public void dispose()
	{
		super.dispose();

		fViewer = null;
	}

	protected void handleResources()
	{

		Object[] resources = HierarchyResourceSetImpl.getInstance()
				.getResources().toArray();
		for (int idx = 0; idx < resources.length; idx++)
		{
			Resource element = (Resource) resources[idx];
			if (element != null && element.isLoaded())
			{
				Object[] elements = element.getContents().toArray();
				for (int i = 0; i < elements.length; i++)
				{
					Object obj = elements[i];

					List deletelist = TraceUIManager.getTraceUIManager().getDeleteListeners();
					for (int j = 0; j < deletelist.size(); j++)
					{
						((IDeleteListener) deletelist.get(j)).deregister(obj);
					}

					if (obj instanceof TRCAgent)
					{
						element.unload();
					}
				}
			}
		}
	}
}
