/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RefreshTreeAction.java,v 1.8 2009/04/09 21:42:57 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.common.ui.trace.internal.actions;

import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

/*
 * CONTEXT_ID refr0000 for refresh tree action
 */

public class RefreshTreeAction extends SelectionProviderAction implements ISelectionChangedListener
{
	public class RefreshResourceDialog extends MessageDialog
	{

		protected boolean refreshContent = false;

		protected Button radio1;

		protected Button radio2;
		
		static final String CONTINUE_LABEL="&Continue";
		
		public RefreshResourceDialog(Shell parentShell)
		{
			super(parentShell, CommonUITraceMessages.TRC_MSGT, null,
			// accept the default window icon
					CommonUITraceMessages.CRTREE, MessageDialog.QUESTION, new String[] { CONTINUE_LABEL, IDialogConstants.CANCEL_LABEL }, 0);
			// yes is the default
			setShellStyle(getShellStyle() | SWT.RESIZE);
		}

		protected Control createCustomArea(Composite parent)
		{
			Composite composite = new Composite(parent, SWT.NONE);
			composite.setLayout(new GridLayout());
			radio1 = new Button(composite, SWT.RADIO);
			radio1.addSelectionListener(selectionListener);
			String text1 = CommonUITraceMessages.RTREE_SYS;
			radio1.setText(text1);

			radio2 = new Button(composite, SWT.RADIO);
			radio2.addSelectionListener(selectionListener);
			String text2 = CommonUITraceMessages.RTREE_RES;
			radio2.setText(text2);

			Label empty = new Label(composite, SWT.NONE);
			Label messageLbl = new Label(composite, SWT.WRAP);
			messageLbl.setText(CommonUITraceMessages.REFRESH_WARNING);

			GridDataFactory
			.fillDefaults()
			.align(SWT.FILL, SWT.BEGINNING)
			.grab(true, false)
			.hint(convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH),
					SWT.DEFAULT).applyTo(messageLbl);
			
			// set initial state
			radio1.setSelection(refreshContent);
			radio2.setSelection(!refreshContent);

			return composite;
		}

		protected SelectionListener selectionListener = new SelectionAdapter()
		{
			public void widgetSelected(SelectionEvent e)
			{
				Button button = (Button) e.widget;
				if (button.getSelection())
				{
					refreshContent = (button == radio1);
				}
			}
		};

		public boolean getRefreshContent()
		{
			return refreshContent;
		}
	}

	protected INavigator fViewer;
	protected boolean refreshContents;

	public boolean getRefreshContents() {
		return refreshContents;
	}

	public RefreshTreeAction(INavigator viewer)
	{
		super(viewer.getViewer(), CommonUITraceMessages.REFRESH);
		setDescription(CommonUITraceMessages.RTREE);
		CommonUIImages.setActionImage(CommonUITraceImages.INSTANCE, this, CommonUITraceImages.IMG_REFRESH);
		fViewer = viewer;

		PlatformUI.getWorkbench().getHelpSystem().setHelp(this, CommonUITracePlugin.PLUGIN_ID + ".refr0000");

		setToolTipText(CommonUITraceMessages.RTREET);
	}

	public void run()
	{
		RefreshResourceDialog dlg = new RefreshResourceDialog(fViewer.getViewSite().getShell());
		if (dlg.open() != 0)
			return;

		refreshContents = dlg.getRefreshContent();

		if (refreshContents)
		{
			PDContentProvider.resetMonitors();

			Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
			for (int idx = 0; idx < resources.length; idx++)
			{
				Resource element = (Resource) resources[idx];
				if (element != null && element.isLoaded())
				{
					Object[] elements = element.getContents().toArray();
					for (int i = 0; i < elements.length; i++)
					{
						Object obj = elements[i];

						List deletelist = TraceUIManager.getTraceUIManager().getDeleteListeners();
						for (int j = 0; j < deletelist.size(); j++)
						{
							((IDeleteListener) deletelist.get(j)).deregister(obj);
						}

						element.unload();
					}
				}
			}
			
			if(fViewer.getID()!=null && fViewer.getID().equals(CommonUIConstants.LOG_NAVIGATOR_ID)){
				ProfileEvent event = new ProfileEvent();
				event.setSource(ResourcesPlugin.getWorkspace().getRoot());		
				event.setType(ProfileEvent.REFRESH_LOG_NAVIGATOR);
				TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
			}else{
				fViewer.getViewer().refresh();
			}

		} else
		{
			fViewer.getViewer().refresh();
		}

	}

	public void selectionChanged(IStructuredSelection selection)
	{
		setEnabled(true);
	}

	public void dispose()
	{

		super.dispose();

		fViewer = null;
	}

}
