/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonUITraceUtil.java,v 1.2 2007/05/04 03:36:00 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.common.ui.trace.internal.util;

import java.net.URL;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;

public class CommonUITraceUtil
{
	/**
	 * Returns the image descriptor using the attribute value 'attributeName' of
	 * the configuration element passed in
	 * 
	 * @param attributeName The attributeName
	 * @param configurationElement The configuration element
	 * 
	 * @return An image descriptor if it can be resolved; null otherwise.
	 */
	public static ImageDescriptor resolveImageDescriptor(IConfigurationElement element, String attributeName)
	{
		String iconPath = element.getAttribute(attributeName);
		
		/* Remove the variables */
		IPath path = new Path (iconPath);
		IPath finalPath = new Path("");
		for (int i = 0, segmentCount = path.segmentCount(); i < segmentCount; i++)
		{
			String currentSegment = path.segment(i);
			if (currentSegment.startsWith("$") && currentSegment.endsWith("$"))
				continue;
			finalPath = finalPath.append(currentSegment);
		}
		ImageDescriptor icon = null;	
		if(finalPath.segmentCount() > 0)
		{
			try 
			{
				URL pluginInstallUrl = Platform.getBundle(element.getDeclaringExtension().getNamespaceIdentifier()).getEntry("/"); //$NON-NLS-1$							
				icon = ImageDescriptor.createFromURL(new URL(pluginInstallUrl + finalPath.toString()));
			} 
			catch (Exception e) 
			{
				/* Set the icon to null */
				icon = null;
			}					
		}
		
		return icon;
	}
}
